/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.spring.quartz1;

import com.atlassian.spring.quartz1.SchedulerAccessor;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.impl.SchedulerRepository;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.ListableBeanFactory;

public class SchedulerAccessorBean
extends SchedulerAccessor
implements BeanFactoryAware,
InitializingBean {
    private String schedulerName;
    private Scheduler scheduler;
    private BeanFactory beanFactory;

    public void setSchedulerName(String schedulerName) {
        this.schedulerName = schedulerName;
    }

    public void setScheduler(Scheduler scheduler) {
        this.scheduler = scheduler;
    }

    @Override
    public Scheduler getScheduler() {
        return this.scheduler;
    }

    public void setBeanFactory(BeanFactory beanFactory) {
        this.beanFactory = beanFactory;
    }

    public void afterPropertiesSet() throws SchedulerException {
        if (this.scheduler == null) {
            if (this.schedulerName != null) {
                this.scheduler = this.findScheduler(this.schedulerName);
            } else {
                throw new IllegalStateException("No Scheduler specified");
            }
        }
        this.registerListeners();
        this.registerJobsAndTriggers();
    }

    protected Scheduler findScheduler(String schedulerName) throws SchedulerException {
        Scheduler schedulerInRepo;
        if (this.beanFactory instanceof ListableBeanFactory) {
            String[] beanNames;
            ListableBeanFactory lbf = (ListableBeanFactory)this.beanFactory;
            for (String beanName : beanNames = lbf.getBeanNamesForType(Scheduler.class)) {
                Scheduler schedulerBean = (Scheduler)lbf.getBean(beanName);
                if (!schedulerName.equals(schedulerBean.getSchedulerName())) continue;
                return schedulerBean;
            }
        }
        if ((schedulerInRepo = SchedulerRepository.getInstance().lookup(schedulerName)) == null) {
            throw new IllegalStateException("No Scheduler named '" + schedulerName + "' found");
        }
        return schedulerInRepo;
    }
}

