/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.soy.impl;

import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.event.PluginEventListener;
import com.atlassian.plugin.event.PluginEventManager;
import com.atlassian.plugin.event.events.PluginModuleDisabledEvent;
import com.atlassian.plugin.event.events.PluginModuleEnabledEvent;
import com.atlassian.plugin.servlet.ServletContextFactory;
import com.atlassian.soy.impl.DevMode;
import com.atlassian.soy.impl.QuieterSoySyntaxException;
import com.atlassian.soy.impl.SoyDependencyInjectorFactory;
import com.atlassian.soy.impl.SoyManager;
import com.atlassian.soy.impl.TemplateSetFactory;
import com.atlassian.soy.impl.data.SoyDataConverter;
import com.atlassian.soy.impl.modules.GuiceModuleSupplier;
import com.atlassian.soy.renderer.SoyException;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.collect.ComputationException;
import com.google.common.io.Closeables;
import com.google.inject.Injector;
import com.google.template.soy.SoyFileSet;
import com.google.template.soy.base.SoySyntaxException;
import com.google.template.soy.data.SoyMapData;
import com.google.template.soy.msgs.SoyMsgBundle;
import com.google.template.soy.parseinfo.SoyTemplateInfo;
import com.google.template.soy.shared.SoyCssRenamingMap;
import com.google.template.soy.tofu.SoyTofu;
import java.io.Closeable;
import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultSoyManager
implements SoyManager {
    private static final SoyTofu DIDNOTCOMPILE = new NullTofu();
    private static final Logger log = LoggerFactory.getLogger(DefaultSoyManager.class);
    public static final int INJECTOR_CACHE_EXPIRY_TIME = 45;
    public static final TimeUnit INJECTOR_CACHE_EXPIRY_TIME_UNIT = TimeUnit.MINUTES;
    private final SoyDataConverter soyDataConverter;
    private final Cache<String, SoyTofu> soyTofuCache;
    private final Cache<String, Long> lastModifiedCache;
    private final TemplateSetFactory templateSetFactory;
    private final SoyDependencyInjectorFactory soyDependencyInjectorFactory;

    public DefaultSoyManager(PluginAccessor pluginAccessor, PluginEventManager pluginEventManager, ServletContextFactory servletContextFactory, GuiceModuleSupplier moduleSupplier, SoyDataConverter soyDataConverter) {
        this.soyDataConverter = soyDataConverter;
        this.soyTofuCache = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<String, SoyTofu>(){

            public SoyTofu load(String key) throws SoyException {
                SoyTofu soyTofu = DefaultSoyManager.this.strainTofu(key);
                if (soyTofu != null) {
                    return soyTofu;
                }
                return DIDNOTCOMPILE;
            }
        });
        this.lastModifiedCache = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<String, Long>(){

            public Long load(String key) {
                return DefaultSoyManager.this.getLastModifiedForModule(key);
            }
        });
        this.soyDependencyInjectorFactory = new SoyDependencyInjectorFactory(moduleSupplier);
        this.templateSetFactory = new TemplateSetFactory(pluginAccessor, servletContextFactory, 45, INJECTOR_CACHE_EXPIRY_TIME_UNIT);
        pluginEventManager.register((Object)this);
    }

    @Override
    public void render(Appendable appendable, String completeModuleKey, String templateName, Map<String, Object> data, Map<String, Object> injectedData) throws SoyException {
        if (DevMode.isDevMode()) {
            log.debug("Clearing caches in dev mode");
            this.clearCaches(completeModuleKey);
        }
        try {
            SoyTofu tofu = (SoyTofu)this.soyTofuCache.getUnchecked((Object)completeModuleKey);
            if (tofu == DIDNOTCOMPILE) {
                throw new SoyException("Unable to compile Soy template in plugin module: " + completeModuleKey);
            }
            tofu.newRenderer(templateName).setData(this.soyDataConverter.convertToSoyMapData(data)).setIjData(this.soyDataConverter.convertToSoyMapData(injectedData)).render(appendable);
        }
        catch (ComputationException e) {
            throw new SoyException("Unable to compile Soy template in plugin module: " + completeModuleKey, e.getCause());
        }
    }

    @PluginEventListener
    public void pluginModuleEnabled(PluginModuleEnabledEvent event) {
        this.clearCaches(null);
    }

    @PluginEventListener
    public void pluginModuleDisabled(PluginModuleDisabledEvent event) {
        this.clearCaches(null);
    }

    @Override
    public void clearCaches(String completeModuleKey) {
        this.soyDependencyInjectorFactory.clear();
        this.templateSetFactory.clear();
        if (completeModuleKey == null) {
            this.soyTofuCache.invalidateAll();
        } else if (this.isModified(completeModuleKey)) {
            this.soyTofuCache.invalidate((Object)completeModuleKey);
            this.lastModifiedCache.invalidate((Object)completeModuleKey);
        }
    }

    private long getLastModifiedForModule(String completeModuleKey) {
        long lastModified = 0L;
        for (URL url : this.templateSetFactory.get(completeModuleKey)) {
            lastModified = Math.max(lastModified, DefaultSoyManager.getLastModified(url));
        }
        return lastModified;
    }

    private boolean isModified(String completeModuleKey) {
        Long previousModifiedDate = (Long)this.lastModifiedCache.getUnchecked((Object)completeModuleKey);
        long currentModifiedDate = this.getLastModifiedForModule(completeModuleKey);
        return previousModifiedDate < currentModifiedDate || currentModifiedDate == -1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static long getLastModified(URL url) {
        long l;
        URLConnection urlConnection = url.openConnection();
        try {
            l = urlConnection.getLastModified();
        }
        catch (Throwable throwable) {
            try {
                Closeables.closeQuietly((Closeable)urlConnection.getInputStream());
                throw throwable;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        Closeables.closeQuietly((Closeable)urlConnection.getInputStream());
        return l;
    }

    private SoyTofu strainTofu(String completeModuleKey) throws SoyException {
        SoyFileSet.Builder builder = this.makeSoyFileSetBuilder();
        for (URL file : this.templateSetFactory.get(completeModuleKey)) {
            builder.add(file);
        }
        try {
            return builder.build().compileToTofu();
        }
        catch (SoySyntaxException e) {
            if (DevMode.isDevMode()) {
                throw new QuieterSoySyntaxException(e.getMessage());
            }
            throw e;
        }
    }

    @Override
    public SoyFileSet.Builder makeSoyFileSetBuilder() {
        Injector injector = this.soyDependencyInjectorFactory.get();
        return (SoyFileSet.Builder)injector.getInstance(SoyFileSet.Builder.class);
    }

    private static class NullTofu
    implements SoyTofu {
        private NullTofu() {
        }

        public String getNamespace() {
            return null;
        }

        public SoyTofu forNamespace(String namespace) {
            return null;
        }

        public String render(SoyTemplateInfo templateInfo, Map<String, ?> data, SoyMsgBundle msgBundle) {
            return null;
        }

        public String render(SoyTemplateInfo templateInfo, SoyMapData data, SoyMsgBundle msgBundle) {
            return null;
        }

        public String render(String templateName, Map<String, ?> data, SoyMsgBundle msgBundle) {
            return null;
        }

        public String render(String templateName, SoyMapData data, SoyMsgBundle msgBundle) {
            return null;
        }

        public boolean isCaching() {
            return false;
        }

        public void addToCache(SoyMsgBundle soyMsgBundle, SoyCssRenamingMap soyCssRenamingMap) {
        }

        public SoyTofu.Renderer newRenderer(SoyTemplateInfo soyTemplateInfo) {
            return null;
        }

        public SoyTofu.Renderer newRenderer(String s) {
            return null;
        }
    }
}

