/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.social.opensocial.spi;

import com.google.common.collect.Maps;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class GroupId {
    private Type type;
    private String groupId;

    public GroupId(Type type, String groupId) {
        this.groupId = groupId;
        this.type = type;
    }

    public Type getType() {
        return this.type;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public static GroupId fromJson(String jsonId) {
        Type idSpecEnum = Type.jsonValueOf(jsonId);
        if (idSpecEnum != null) {
            return new GroupId(idSpecEnum, null);
        }
        return new GroupId(Type.groupId, jsonId);
    }

    public boolean equals(Object o) {
        if (!(o instanceof GroupId)) {
            return false;
        }
        GroupId actual = (GroupId)o;
        return this.type == actual.type && StringUtils.equals((CharSequence)this.groupId, (CharSequence)actual.groupId);
    }

    public int hashCode() {
        int groupHashCode = 0;
        if (this.groupId != null) {
            groupHashCode = this.groupId.hashCode();
        }
        return this.type.hashCode() + groupHashCode;
    }

    public String toString() {
        switch (this.type) {
            case all: {
                return "ALL";
            }
            case deleted: {
                return "DELETE";
            }
            case friends: {
                return "FRIENDS";
            }
            case self: {
                return "SELF";
            }
            case groupId: {
                return "GROUPID(" + this.groupId + ")";
            }
        }
        return "UNKNOWN";
    }

    public static enum Type {
        all,
        friends,
        self,
        deleted,
        groupId;

        private static final Map<String, Type> jsonTypeMap;

        public static Type jsonValueOf(String jsonType) {
            return jsonTypeMap.get(jsonType);
        }

        static {
            jsonTypeMap = Maps.newHashMap();
            for (Type type : Type.values()) {
                jsonTypeMap.put("@" + type.name(), type);
            }
        }
    }
}

