/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.social.opensocial.service;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.util.Map;
import org.apache.shindig.social.opensocial.service.ActivityHandler;
import org.apache.shindig.social.opensocial.service.AppDataHandler;
import org.apache.shindig.social.opensocial.service.DataRequestHandler;
import org.apache.shindig.social.opensocial.service.HandlerDispatcher;
import org.apache.shindig.social.opensocial.service.PersonHandler;

public class StandardHandlerDispatcher
implements HandlerDispatcher {
    private final Map<String, Provider<? extends DataRequestHandler>> handlers;

    @Inject
    public StandardHandlerDispatcher(Provider<PersonHandler> personHandlerProvider, Provider<ActivityHandler> activityHandlerProvider, Provider<AppDataHandler> appDataHandlerProvider) {
        this((Map<String, Provider<? extends DataRequestHandler>>)ImmutableMap.of((Object)"people", personHandlerProvider, (Object)"activities", activityHandlerProvider, (Object)"appdata", appDataHandlerProvider));
    }

    public StandardHandlerDispatcher(Map<String, Provider<? extends DataRequestHandler>> handlers) {
        this.handlers = Maps.newHashMap(handlers);
    }

    @Override
    public DataRequestHandler getHandler(String service) {
        Provider<? extends DataRequestHandler> provider = this.handlers.get(service);
        if (provider == null) {
            return null;
        }
        return (DataRequestHandler)provider.get();
    }

    public void addHandler(String service, Provider<? extends DataRequestHandler> handler) {
        this.handlers.put(service, handler);
    }
}

