/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.social.opensocial.service;

import com.google.inject.Inject;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Future;
import org.apache.shindig.social.ResponseError;
import org.apache.shindig.social.core.util.ContainerConf;
import org.apache.shindig.social.opensocial.service.DataRequestHandler;
import org.apache.shindig.social.opensocial.service.RequestItem;
import org.apache.shindig.social.opensocial.spi.AppDataService;
import org.apache.shindig.social.opensocial.spi.SocialSpiException;
import org.apache.shindig.social.opensocial.spi.UserId;

public class AppDataHandler
extends DataRequestHandler {
    private final AppDataService service;
    private static final String APP_DATA_PATH = "/appdata/{userId}+/{groupId}/{appId}";

    @Inject
    public AppDataHandler(AppDataService service, ContainerConf containerConf) {
        super(containerConf);
        this.service = service;
    }

    @Override
    protected Future<?> handleDelete(RequestItem request) throws SocialSpiException {
        request.applyUrlTemplate(APP_DATA_PATH);
        Set<UserId> userIds = request.getUsers();
        DataRequestHandler.Preconditions.requireNotEmpty(userIds, "No userId specified");
        DataRequestHandler.Preconditions.requireSingular(userIds, "Multiple userIds not supported");
        return this.service.deletePersonData(userIds.iterator().next(), request.getGroup(), request.getAppId(), request.getFields(), request.getToken());
    }

    @Override
    protected Future<?> handlePut(RequestItem request) throws SocialSpiException {
        return this.handlePost(request);
    }

    @Override
    protected Future<?> handlePost(RequestItem request) throws SocialSpiException {
        request.applyUrlTemplate(APP_DATA_PATH);
        Set<UserId> userIds = request.getUsers();
        DataRequestHandler.Preconditions.requireNotEmpty(userIds, "No userId specified");
        DataRequestHandler.Preconditions.requireSingular(userIds, "Multiple userIds not supported");
        Map values = request.getTypedParameter("data", HashMap.class);
        for (String key : values.keySet()) {
            if (AppDataHandler.isValidKey(key)) continue;
            throw new SocialSpiException(ResponseError.BAD_REQUEST, "One or more of the app data keys are invalid: " + key);
        }
        return this.service.updatePersonData(userIds.iterator().next(), request.getGroup(), request.getAppId(), request.getFields(), values, request.getToken());
    }

    @Override
    protected Future<?> handleGet(RequestItem request) throws SocialSpiException {
        request.applyUrlTemplate(APP_DATA_PATH);
        Set<UserId> userIds = request.getUsers();
        DataRequestHandler.Preconditions.requireNotEmpty(userIds, "No userId specified");
        return this.service.getPersonData(userIds, request.getGroup(), request.getAppId(), request.getFields(), request.getToken());
    }

    public static boolean isValidKey(String key) {
        if (key == null || key.length() == 0) {
            return false;
        }
        for (int i = 0; i < key.length(); ++i) {
            char c = key.charAt(i);
            if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || c == '-' || c == '_' || c == '.') continue;
            return false;
        }
        return true;
    }
}

