/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.social.core.util.xstream;

import com.google.common.collect.Lists;
import com.google.inject.Injector;
import com.thoughtworks.xstream.converters.reflection.ObjectAccessException;
import com.thoughtworks.xstream.core.util.OrderRetainingMap;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.WeakHashMap;

public class GuiceBeanProvider {
    protected static final Object[] NO_PARAMS = new Object[0];
    private final Comparator<String> propertyNameComparator;
    private final transient Map<Class<?>, Map<String, PropertyDescriptor>> propertyNameCache = new WeakHashMap();
    private Injector injector;

    public GuiceBeanProvider(Injector injector) {
        this(injector, null);
    }

    public GuiceBeanProvider(Injector injector, Comparator<String> propertyNameComparator) {
        this.propertyNameComparator = propertyNameComparator;
        this.injector = injector;
    }

    public Object newInstance(Class<?> type) {
        return this.injector.getInstance(type);
    }

    public void visitSerializableProperties(Object object, Visitor visitor) {
        PropertyDescriptor[] propertyDescriptors = this.getSerializableProperties(object);
        for (int i = 0; i < propertyDescriptors.length; ++i) {
            PropertyDescriptor property = propertyDescriptors[i];
            try {
                Method readMethod = property.getReadMethod();
                String name = property.getName();
                Class<?> definedIn = readMethod.getDeclaringClass();
                if (!visitor.shouldVisit(name, definedIn)) continue;
                Object value = readMethod.invoke(object, new Object[0]);
                visitor.visit(name, property.getPropertyType(), definedIn, value);
                continue;
            }
            catch (IllegalArgumentException e) {
                throw new ObjectAccessException("Could not get property " + object.getClass() + "." + property.getName(), (Throwable)e);
            }
            catch (IllegalAccessException e) {
                throw new ObjectAccessException("Could not get property " + object.getClass() + "." + property.getName(), (Throwable)e);
            }
            catch (InvocationTargetException e) {
                throw new ObjectAccessException("Could not get property " + object.getClass() + "." + property.getName(), (Throwable)e);
            }
        }
    }

    public void writeProperty(Object object, String propertyName, Object value) {
        PropertyDescriptor property = this.getProperty(propertyName, object.getClass());
        try {
            property.getWriteMethod().invoke(object, value);
        }
        catch (IllegalArgumentException e) {
            throw new ObjectAccessException("Could not set property " + object.getClass() + "." + property.getName(), (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new ObjectAccessException("Could not set property " + object.getClass() + "." + property.getName(), (Throwable)e);
        }
        catch (InvocationTargetException e) {
            throw new ObjectAccessException("Could not set property " + object.getClass() + "." + property.getName(), (Throwable)e);
        }
    }

    public Class<?> getPropertyType(Object object, String name) {
        return this.getProperty(name, object.getClass()).getPropertyType();
    }

    public boolean propertyDefinedInClass(String name, Class<?> type) {
        return this.getProperty(name, type) != null;
    }

    private PropertyDescriptor[] getSerializableProperties(Object object) {
        Map<String, PropertyDescriptor> nameMap = this.getNameMap(object.getClass());
        ArrayList result = Lists.newArrayListWithExpectedSize((int)nameMap.size());
        Set<String> names = nameMap.keySet();
        if (this.propertyNameComparator != null) {
            TreeSet<String> sortedSet = new TreeSet<String>(this.propertyNameComparator);
            sortedSet.addAll(names);
            names = sortedSet;
        }
        for (String name : names) {
            PropertyDescriptor descriptor = nameMap.get(name);
            if (!this.canStreamProperty(descriptor)) continue;
            result.add(descriptor);
        }
        return result.toArray(new PropertyDescriptor[result.size()]);
    }

    protected boolean canStreamProperty(PropertyDescriptor descriptor) {
        return descriptor.getReadMethod() != null && descriptor.getWriteMethod() != null;
    }

    public boolean propertyWriteable(String name, Class<?> type) {
        PropertyDescriptor property = this.getProperty(name, type);
        return property.getWriteMethod() != null;
    }

    private PropertyDescriptor getProperty(String name, Class<?> type) {
        return this.getNameMap(type).get(name);
    }

    private Map<String, PropertyDescriptor> getNameMap(Class<?> type) {
        OrderRetainingMap nameMap = this.propertyNameCache.get(type);
        if (nameMap == null) {
            BeanInfo beanInfo;
            try {
                beanInfo = Introspector.getBeanInfo(type, Object.class);
            }
            catch (IntrospectionException e) {
                throw new ObjectAccessException("Cannot get BeanInfo of type " + type.getName(), (Throwable)e);
            }
            nameMap = new OrderRetainingMap();
            this.propertyNameCache.put(type, (Map<String, PropertyDescriptor>)nameMap);
            PropertyDescriptor[] propertyDescriptors = beanInfo.getPropertyDescriptors();
            for (int i = 0; i < propertyDescriptors.length; ++i) {
                PropertyDescriptor descriptor = propertyDescriptors[i];
                nameMap.put(descriptor.getName(), descriptor);
            }
        }
        return nameMap;
    }

    static interface Visitor {
        public boolean shouldVisit(String var1, Class<?> var2);

        public void visit(String var1, Class<?> var2, Class<?> var3, Object var4);
    }
}

