/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.social.core.util;

import java.util.Map;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JsonLibConverterUtils {
    protected static final Logger LOG = LoggerFactory.getLogger(JsonLibConverterUtils.class);

    public static final void dumpJsonObject(JSONObject jsonObject, String indent) {
        for (Object o : jsonObject.entrySet()) {
            Map.Entry entry = (Map.Entry)o;
            Object key = entry.getKey();
            Object value = entry.getValue();
            if (value instanceof JSONObject) {
                LOG.info(indent + key + ":JSONObject");
                JsonLibConverterUtils.dumpJsonObject((JSONObject)value, indent + "  ");
                continue;
            }
            if (value instanceof JSONArray) {
                LOG.info(indent + key + ":JSONArray " + ((JSONArray)value).size());
                JsonLibConverterUtils.dumpJsonArray((JSONArray)value, indent + "  ");
                continue;
            }
            if (value == null) {
                LOG.info(indent + key + ":null:na");
                continue;
            }
            LOG.info(indent + key + ":" + value + ":" + value.getClass());
        }
    }

    public static void dumpJsonArray(JSONArray array, String indent) {
        for (Object value : array) {
            if (value instanceof JSONObject) {
                LOG.info(indent + ":JSONObject");
                JsonLibConverterUtils.dumpJsonObject((JSONObject)value, indent + "  ");
                continue;
            }
            if (value instanceof JSONArray) {
                LOG.info(indent + ":JSONArray " + ((JSONArray)value).size());
                JsonLibConverterUtils.dumpJsonArray((JSONArray)value, indent + "  ");
                continue;
            }
            LOG.info(indent + ":" + value + ":" + (value == null ? "na" : value.getClass()));
        }
    }
}

