/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.social.core.util;

import com.google.common.collect.Maps;
import com.google.inject.Inject;
import com.thoughtworks.xstream.converters.reflection.PureJavaReflectionProvider;
import com.thoughtworks.xstream.converters.reflection.ReflectionProvider;
import com.thoughtworks.xstream.core.ClassLoaderReference;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.xml.XppDriver;
import com.thoughtworks.xstream.mapper.DefaultMapper;
import com.thoughtworks.xstream.mapper.Mapper;
import java.util.Map;
import org.apache.shindig.social.core.util.xstream.StackDriver;
import org.apache.shindig.social.core.util.xstream.ThreadSafeWriterStack;
import org.apache.shindig.social.core.util.xstream.WriterStack;
import org.apache.shindig.social.core.util.xstream.XStreamConfiguration;
import org.apache.shindig.social.opensocial.service.BeanConverter;
import org.apache.shindig.social.opensocial.spi.DataCollection;
import org.apache.shindig.social.opensocial.spi.RestfulCollection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BeanXStreamConverter
implements BeanConverter {
    public static final String XML_DECL = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>";
    private static final XStreamConfiguration.ConverterSet[] MAPPER_SCOPES = new XStreamConfiguration.ConverterSet[]{XStreamConfiguration.ConverterSet.MAP, XStreamConfiguration.ConverterSet.COLLECTION, XStreamConfiguration.ConverterSet.DEFAULT};
    private static final Logger log = LoggerFactory.getLogger(BeanXStreamConverter.class);
    final WriterStack writerStack;
    final Map<XStreamConfiguration.ConverterSet, XStreamConfiguration.ConverterConfig> converterMap = Maps.newHashMap();

    @Inject
    public BeanXStreamConverter(XStreamConfiguration configuration) {
        PureJavaReflectionProvider rp = new PureJavaReflectionProvider();
        DefaultMapper defaultMapper = new DefaultMapper(new ClassLoaderReference(this.getClass().getClassLoader()));
        this.writerStack = new ThreadSafeWriterStack();
        StackDriver driver = new StackDriver((HierarchicalStreamDriver)new XppDriver(), this.writerStack, configuration.getNameSpaces());
        for (XStreamConfiguration.ConverterSet converterSet : MAPPER_SCOPES) {
            XStreamConfiguration.ConverterConfig converterConfig = configuration.getConverterConfig(converterSet, (ReflectionProvider)rp, (Mapper)defaultMapper, driver, this.writerStack);
            this.converterMap.put(converterSet, converterConfig);
        }
    }

    @Override
    public String getContentType() {
        return "application/xml";
    }

    @Override
    public String convertToString(Object pojo) {
        return this.convertToXml(pojo);
    }

    private String convertToXml(Object obj) {
        this.writerStack.reset();
        if (obj instanceof Map) {
            Map m = (Map)obj;
            XStreamConfiguration.ConverterConfig cc = this.converterMap.get((Object)XStreamConfiguration.ConverterSet.MAP);
            if (m.size() == 1) {
                Object s = m.values().iterator().next();
                cc.mapper.setBaseObject(s);
                String result = cc.xstream.toXML(s);
                log.debug("Result is " + result);
                return "<response>" + result + "</response>";
            }
        } else {
            if (obj instanceof RestfulCollection) {
                XStreamConfiguration.ConverterConfig cc = this.converterMap.get((Object)XStreamConfiguration.ConverterSet.COLLECTION);
                cc.mapper.setBaseObject(obj);
                String result = cc.xstream.toXML(obj);
                log.debug("Result is " + result);
                return result;
            }
            if (obj instanceof DataCollection) {
                XStreamConfiguration.ConverterConfig cc = this.converterMap.get((Object)XStreamConfiguration.ConverterSet.MAP);
                cc.mapper.setBaseObject(obj);
                String result = cc.xstream.toXML(obj);
                log.debug("Result is " + result);
                return result;
            }
        }
        XStreamConfiguration.ConverterConfig cc = this.converterMap.get((Object)XStreamConfiguration.ConverterSet.DEFAULT);
        cc.mapper.setBaseObject(obj);
        String result = cc.xstream.toXML(obj);
        log.debug("Result is " + result);
        return "<response>" + result + "</response>";
    }

    @Override
    public <T> T convertToObject(String xml, Class<T> className) {
        XStreamConfiguration.ConverterConfig cc = this.converterMap.get((Object)XStreamConfiguration.ConverterSet.DEFAULT);
        return (T)cc.xstream.fromXML(xml);
    }
}

