/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.permission;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.permission.PermissionSchemeEntry;
import com.atlassian.jira.permission.PermissionSchemeManager;
import com.atlassian.jira.permission.PermissionTypeManager;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.scheme.Scheme;
import com.atlassian.jira.scheme.SchemeType;
import com.atlassian.jira.security.plugin.ProjectPermissionKey;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.ApplicationUsers;
import com.atlassian.servicedesk.bridge.api.permission.ReversePermissionManager;
import com.atlassian.servicedesk.bridge.api.permission.SecurityTypeAndSecurityTypeParameter;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class ReversePermissionManager64
implements ReversePermissionManager {
    private final PermissionSchemeManager permissionSchemeManager;

    public ReversePermissionManager64(PermissionSchemeManager permissionSchemeManager) {
        this.permissionSchemeManager = permissionSchemeManager;
    }

    public List<SecurityTypeAndSecurityTypeParameter> getMatchingSecurityTypes(ProjectPermissionKey permissionKey, Project project, ApplicationUser user) {
        PermissionTypeManager permissionTypeManager = (PermissionTypeManager)ComponentAccessor.getComponent(PermissionTypeManager.class);
        Map securityTypes = permissionTypeManager.getTypes();
        Scheme scheme = this.permissionSchemeManager.getSchemeFor(project);
        Collection permissionSchemeEntries = this.permissionSchemeManager.getPermissionSchemeEntries(scheme, permissionKey);
        ArrayList matches = Lists.newArrayList();
        for (PermissionSchemeEntry permissionSchemeEntity : permissionSchemeEntries) {
            String typeString;
            SchemeType schemeType;
            if (permissionSchemeEntity == null || (schemeType = (SchemeType)securityTypes.get(typeString = permissionSchemeEntity.getType())) == null) continue;
            String parameterString = permissionSchemeEntity.getParameter();
            if (typeString.equals("group") && StringUtils.isBlank((String)parameterString)) {
                matches.add(new SecurityTypeAndSecurityTypeParameter(typeString, null));
                continue;
            }
            if (user == null) {
                if (!schemeType.hasPermission(project, parameterString)) continue;
                matches.add(new SecurityTypeAndSecurityTypeParameter(typeString, parameterString));
                continue;
            }
            if (!schemeType.hasPermission(project, parameterString, ApplicationUsers.toDirectoryUser((ApplicationUser)user), false)) continue;
            matches.add(new SecurityTypeAndSecurityTypeParameter(typeString, parameterString));
        }
        return matches;
    }
}

