/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal;

import com.atlassian.pocketknife.api.version.JiraVersionService;
import com.atlassian.pocketknife.api.version.SoftwareVersion;
import com.atlassian.pocketknife.api.version.VersionKit;
import com.atlassian.servicedesk.internal.BridgeBeanFactory;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class OptionallySupportedBridgeBeanFactory<T>
extends BridgeBeanFactory<T> {
    @Autowired
    private JiraVersionService jiraVersionService;

    protected OptionallySupportedBridgeBeanFactory(Class<T> clazz) {
        super(clazz);
    }

    protected abstract T getBean();

    protected abstract T getBeanWhenUnsupported();

    protected abstract boolean isBeanSupported();

    protected SoftwareVersion currentJiraVersion() {
        return this.jiraVersionService.version();
    }

    protected boolean isJiraSixTwoSixOrNewer() {
        return VersionKit.version((int)6, (int[])new int[]{2, 6}).isLessThanOrEqualTo(this.currentJiraVersion());
    }

    protected boolean isJiraSixFourOrNewer() {
        SoftwareVersion currentVersion = this.currentJiraVersion();
        boolean validMilestone = currentVersion.getMajorVersion() == 6 && currentVersion.getMinorVersion() == 4;
        return validMilestone || VersionKit.version((int)6, (int[])new int[]{4}).isLessThanOrEqualTo(this.currentJiraVersion());
    }

    @Override
    public Object getObject() throws Exception {
        if (this.isBeanSupported()) {
            return this.getBean();
        }
        return this.getBeanWhenUnsupported();
    }
}

