/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.bridge.internal.license;

import com.atlassian.fugue.Option;
import com.atlassian.servicedesk.bridge.api.license.ServiceDeskLicenseState;
import org.apache.commons.lang.StringUtils;

public class ServiceDeskLicenseStateHelper {
    public static ServiceDeskLicenseState getServiceDeskLicenseState(String licenseString) {
        return new ServiceDeskLicenseStateImpl(licenseString);
    }

    public static boolean equals(ServiceDeskLicenseState oldState, ServiceDeskLicenseState newState) {
        if (oldState == null) {
            return newState == null || !newState.isLicensePresent();
        }
        return newState != null && newState.equals(oldState);
    }

    private static class ServiceDeskLicenseStateImpl
    implements ServiceDeskLicenseState {
        private final Option<String> licenseString;

        private ServiceDeskLicenseStateImpl(String licenseString) {
            this.licenseString = StringUtils.isBlank((String)licenseString) ? Option.none() : Option.some((Object)licenseString);
        }

        @Override
        public boolean isLicensePresent() {
            return this.licenseString.isDefined();
        }

        @Override
        public boolean equals(ServiceDeskLicenseState state) {
            if (state == null) {
                return this.licenseString.isEmpty();
            }
            return state instanceof ServiceDeskLicenseStateImpl && ((ServiceDeskLicenseStateImpl)state).licenseString.equals(this.licenseString);
        }
    }
}

