/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.seraph.cookie;

import com.atlassian.seraph.cookie.CookieEncoder;

public class InsecureCookieEncoder
implements CookieEncoder {
    private static final char DELIMITER = '\u0013';
    private static final int ENCODE_XORMASK = 90;
    private static final char ENCODE_CHAR_OFFSET1 = 'C';
    private static final char ENCODE_CHAR_OFFSET2 = 'i';

    @Override
    public String encodePasswordCookie(String username, String password, String encoding) {
        StringBuffer buf = new StringBuffer();
        if (username != null && password != null) {
            int offset1 = encoding != null && encoding.length() > 1 ? (int)encoding.charAt(1) : 67;
            int offset2 = encoding != null && encoding.length() > 2 ? (int)encoding.charAt(2) : 105;
            byte[] bytes = (username + '\u0013' + password).getBytes();
            for (int n = 0; n < bytes.length; ++n) {
                int b = bytes[n] ^ 90 + n;
                buf.append((char)(offset1 + (b & 0xF)));
                buf.append((char)(offset2 + (b >> 4 & 0xF)));
            }
        }
        return buf.toString();
    }

    @Override
    public String[] decodePasswordCookie(String cookieVal, String encoding) {
        if (cookieVal == null || cookieVal.length() <= 0) {
            return null;
        }
        int offset1 = encoding != null && encoding.length() > 1 ? (int)encoding.charAt(1) : 67;
        int offset2 = encoding != null && encoding.length() > 2 ? (int)encoding.charAt(2) : 105;
        char[] chars = cookieVal.toCharArray();
        byte[] bytes = new byte[chars.length / 2];
        int m = 0;
        for (int n = 0; n < bytes.length; ++n) {
            int b = chars[m++] - offset1;
            bytes[n] = (byte)((b |= chars[m++] - offset2 << 4) ^ 90 + n);
        }
        cookieVal = new String(bytes);
        int pos = cookieVal.indexOf(19);
        String username = pos < 0 ? "" : cookieVal.substring(0, pos);
        String password = pos < 0 ? "" : cookieVal.substring(pos + 1);
        return new String[]{username, password};
    }

    public String encodePasswordCookie(String username, String password) {
        return this.encodePasswordCookie(username, password, new String(new char[]{'\u0013', 'C', 'i'}));
    }

    public String[] decodePasswordCookie(String cookieVal) {
        return this.decodePasswordCookie(cookieVal, new String(new char[]{'\u0013', 'C', 'i'}));
    }
}

