package com.atlassian.seraph.filter;

import com.atlassian.seraph.RequestParameterConstants;

import javax.servlet.http.HttpServletRequest;

/**
 * This is a filter that logs the user in. It works a little like J2EE form-based seraph, except it looks for the
 * parameters 'os_username' and 'os_password' instead of j_username and j_password.
 * <p>
 * The form post/get action should be the URL of the login servlet/JSP/action - given by SecurityFilter.LOGIN_URL.
 * <p>
 * If the parameters exist and authentication is successful, the user will be redirected by the filter to the URL given
 * by the session attribute at SecurityFilter.ORIGINAL_URL_KEY.
 * <p>
 * If this URL doesn't exist, it will look for a parameter 'os_destination' to use as the redirected URL instead.
 * <p>
 * If neither is found, it is assumed that the page will check the authorisation status and handle redirection itself.
 * <p>
 * From the any other filter in the request, or the servlet/JSP/action which processes the request, you can look up the
 * status of the authorisation attempt. The status is a String request attribute, with the key 'os_authstatus'.
 * <p>
 * The possible statuses are:
 * <ul>
 *  <li> LoginFilter.LOGIN_SUCCESS - the login was processed, and user was logged in
 *  <li> LoginFilter.LOGIN_FAILURE - the login was processed, the user gave a bad username or password
 *  <li> LoginFilter.LOGIN_ERROR - the login was processed, an exception occurred trying to log the user in
 *  <li> LoginFilter.LOGIN_NOATTEMPT - the login was no processed, no form parameters existed
 * </ul>
 */
public class LoginFilter extends PasswordBasedLoginFilter
{
	protected UserPasswordPair extractUserPasswordPair(HttpServletRequest request)
	{
        // check for parameters
        String username = request.getParameter(RequestParameterConstants.OS_USERNAME);
        String password = request.getParameter(RequestParameterConstants.OS_PASSWORD);
        boolean persistentLogin = "true".equals(request.getParameter(RequestParameterConstants.OS_COOKIE));
        return new UserPasswordPair(username, password, persistentLogin);
	}
}
