package com.atlassian.seraph.cookie;

import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.atlassian.seraph.config.SecurityConfigFactory;

import org.apache.log4j.Logger;

/**
 *
 * @deprecated replaced by the {@link com.atlassian.seraph.service.rememberme.RememberMeService} code
 */
public class DefaultCookieHandler implements CookieHandler
{
    private static final Logger log = Logger.getLogger(DefaultCookieHandler.class);

    public void invalidateCookie(HttpServletRequest request, HttpServletResponse response, String cookieName,
            String path)
    {
        if (log.isDebugEnabled())
        {
            log.debug("invalidateCookie " + cookieName + " for path " + path);
        }
        setCookie(request, response, cookieName, null, 0, path);
    }

    public Cookie getCookie(HttpServletRequest request, String name)
    {
        final boolean dbg = log.isDebugEnabled();
        if (dbg) {
            log.debug("Looking for a cookie named : '" + name + "'");
        }
        final Cookie cookies[] = request.getCookies();
        if (cookies == null || name == null || name.length() == 0)
        {
            if (dbg)
            {
                if (cookies == null) {
                    log.debug("The Cookies array in the HTTP request is null");
                }
            }
            return null;
        }
        //Otherwise, we have to do a linear scan for the cookie.
        for (int i = 0; i < cookies.length; i++)
        {
            if (cookies[i].getName().equals(name))
            {
                return cookies[i];
            }
        }
        if (dbg)
        {
            log.debug("No cookie was found with name :" + name);
        }
        return null;
    }

    public Cookie setCookie(HttpServletRequest request, HttpServletResponse response, String name, String value,
            int maxAge, String path)
    {
        final boolean isInSecureCookie = SecurityConfigFactory.getInstance().isInsecureCookie();
        if (log.isDebugEnabled())
        {
            log.debug("setCookie " + name + ":" + value + " path : " + path + " maxAge : " + maxAge + (isInSecureCookie ? " insecure" : " secure"));
        }
        Cookie cookie = new Cookie(name, value);
        cookie.setMaxAge(maxAge);
        cookie.setPath(path);
        if (!isInSecureCookie)
        {
            cookie.setSecure(request.isSecure());
        }

        response.addCookie(cookie);

        return cookie;
    }

    public String getCookieValue(HttpServletRequest request, String name)
    {
        Cookie cookie = getCookie(request, name);
        if (cookie != null)
        {
            return cookie.getValue();
        }
        return null;
    }
}
