/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.seraph.util;

import com.atlassian.seraph.auth.Authenticator;
import com.atlassian.seraph.config.SecurityConfig;
import com.atlassian.seraph.util.CharsetUtils;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import org.apache.commons.codec.binary.Base64;
import org.apache.log4j.Category;

public class SecurityUtils {
    private static final Category log = Category.getInstance(SecurityUtils.class);
    private static final String BASIC_AUTHZ_TYPE_PREFIX = "Basic ";
    private static final String ALREADY_FILTERED = "loginfilter.already.filtered";

    public static Authenticator getAuthenticator(ServletContext servletContext) {
        SecurityConfig securityConfig = (SecurityConfig)servletContext.getAttribute("seraph_config");
        if (securityConfig.getAuthenticator() == null) {
            log.error((Object)"ack! Authenticator is null!!!");
        }
        return securityConfig.getAuthenticator();
    }

    public static boolean isBasicAuthorizationHeader(String header) {
        return header != null && header.startsWith(BASIC_AUTHZ_TYPE_PREFIX);
    }

    public static UserPassCredentials decodeBasicAuthorizationCredentials(String basicAuthorizationHeader) {
        String base64Token = basicAuthorizationHeader.substring(BASIC_AUTHZ_TYPE_PREFIX.length());
        String token = SecurityUtils.decodeBase64(base64Token, "ISO-8859-1");
        String userName = "";
        String password = "";
        int delim = token.indexOf(":");
        if (delim != -1) {
            userName = token.substring(0, delim);
            password = token.substring(delim + 1);
        }
        return new UserPassCredentials(userName, password);
    }

    public static String encodeBasicAuthorizationCredentials(String username, String password) {
        return BASIC_AUTHZ_TYPE_PREFIX + SecurityUtils.encodeBase64(username + ":" + password, "ISO-8859-1");
    }

    public static void disableSeraphFiltering(ServletRequest request) {
        request.setAttribute(ALREADY_FILTERED, (Object)true);
    }

    public static boolean isSeraphFilteringDisabled(ServletRequest request) {
        return request.getAttribute(ALREADY_FILTERED) != null;
    }

    private static String decodeBase64(String encodedString, String charset) {
        byte[] encodedBytes = CharsetUtils.bytesFromString(encodedString, "US-ASCII");
        byte[] decodedBytes = Base64.decodeBase64((byte[])encodedBytes);
        return CharsetUtils.stringFromBytes(decodedBytes, charset);
    }

    private static String encodeBase64(String decodedString, String charset) {
        byte[] decodedBytes = CharsetUtils.bytesFromString(decodedString, charset);
        byte[] encodedBytes = Base64.encodeBase64((byte[])decodedBytes);
        return CharsetUtils.stringFromBytes(encodedBytes, "US-ASCII");
    }

    public static class UserPassCredentials {
        private final String username;
        private final String password;

        public UserPassCredentials(String username, String password) {
            this.username = username;
            this.password = password;
        }

        public String getUsername() {
            return this.username;
        }

        public String getPassword() {
            return this.password;
        }
    }
}

