package com.atlassian.seraph.auth;

import com.atlassian.seraph.Initable;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.security.Principal;

/**
 * An Authenticator is used to authenticate users, log them in, log them out and check their roles.
 */
public interface Authenticator extends Initable
{
    /** @deprecated DefaultAuthenticator is no longer a concrete class and there should be no reason to use this constant. Since v2.4.0 */
    public final String DEFAULT_AUTHENTICATOR = "com.atlassian.seraph.auth.DefaultAuthenticator";

    public void destroy();

    public String getRemoteUser(HttpServletRequest request);

    public Principal getUser(HttpServletRequest request);

    public Principal getUser(HttpServletRequest request, HttpServletResponse response);

    /** @deprecated Use {@link RoleMapper} directly */
    public boolean isUserInRole(HttpServletRequest request, String role);

    /**
     * Tries to authenticate a user.
     *
     * @param request             the HttpServletRequest
     * @param response            the HttpServletResponse
     * @param username            the user name to check against the password
     * @param password            the password to authenticate the user with
     * @return Whether the user was authenticated. This should only return false if we were able to actually test and fail the login attempt.
     *
     * @throws AuthenticatorException if an error occurs that stops the user from being authenticated (eg remote communication failure).
     */
    public boolean login(HttpServletRequest request, HttpServletResponse response, String username, String password) throws AuthenticatorException;

    /**
     * Tries to authenticate a user.
     *
     * @param request             the HttpServletRequest
     * @param response            the HttpServletResponse
     * @param username            the user name to check against the password
     * @param password            the password to authenticate the user with
     * @param storeCookie         whether to set a remember me cookie on successful login
     * @return Whether the user was authenticated. This should only return false if we were able to actually test and fail the login attempt.
     *
     * @throws AuthenticatorException if an error occurs that stops the user from being authenticated (eg remote communication failure).
     */
    public boolean login(HttpServletRequest request, HttpServletResponse response, String username, String password, boolean storeCookie) throws AuthenticatorException;

    public boolean logout(HttpServletRequest request, HttpServletResponse response) throws AuthenticatorException;
}
