package com.atlassian.seraph.util;

import org.apache.log4j.Category;

import javax.servlet.ServletContext;

import com.atlassian.seraph.config.SecurityConfig;
import com.atlassian.seraph.auth.Authenticator;

public class SecurityUtils
{
    private static final Category log = Category.getInstance(SecurityUtils.class);

    public static Authenticator getAuthenticator(ServletContext servletContext)
    {
        SecurityConfig securityConfig = (SecurityConfig) servletContext.getAttribute(SecurityConfig.STORAGE_KEY);

        if (securityConfig.getAuthenticator() == null)
        {
            log.error("ack! Authenticator is null!!!");
        }

        return securityConfig.getAuthenticator();
    }
}
