/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.seraph.util;

import com.atlassian.seraph.util.IPathMapper;
import com.atlassian.seraph.util.PathMapper;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CachedPathMapper
implements IPathMapper {
    private final PathMapper delegate = new PathMapper();
    private final ConcurrentMap<String, String> cacheMap;
    private final ConcurrentMap<String, Collection<String>> cacheAllMap;

    public CachedPathMapper() {
        this(new ConcurrentHashMap<String, String>(), new ConcurrentHashMap<String, Collection<String>>());
    }

    public CachedPathMapper(ConcurrentMap<String, String> cacheMap, ConcurrentMap<String, Collection<String>> cacheAllMap) {
        this.cacheMap = cacheMap;
        this.cacheAllMap = cacheAllMap;
    }

    @Override
    public String get(String path) {
        String result = (String)this.cacheMap.get(path);
        if (result != null) {
            return result;
        }
        return this.getWithLock(path);
    }

    private String getWithLock(String path) {
        String result = this.delegate.get(path);
        if (!this.cacheMap.containsKey(path)) {
            this.cacheMap.putIfAbsent(path, result);
        }
        return result;
    }

    @Override
    public Collection<String> getAll(String path) {
        Collection result = (Collection)this.cacheAllMap.get(path);
        if (result == null) {
            this.cacheAllMap.putIfAbsent(path, this.delegate.getAll(path));
            return result;
        }
        return this.getAllWithLock(path);
    }

    private Collection<String> getAllWithLock(String path) {
        Collection<String> result = this.delegate.getAll(path);
        this.cacheAllMap.put(path, result);
        return result;
    }

    public void set(Map<String, String> patterns) {
        Iterator<Map.Entry<String, String>> i$ = patterns.entrySet().iterator();
        while (i$.hasNext()) {
            Map.Entry<String, String> entry2;
            Map.Entry<String, String> entry = entry2 = i$.next();
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public void put(String key, String pattern) {
        this.delegate.put(key, pattern);
        this.cacheMap.remove(key);
        this.cacheAllMap.remove(key);
    }

    public String toString() {
        return this.delegate.toString();
    }
}

