/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.seraph.filter;

import com.atlassian.seraph.auth.Authenticator;
import com.atlassian.seraph.config.SecurityConfig;
import com.atlassian.seraph.config.SecurityConfigFactory;
import com.atlassian.seraph.util.RedirectUtils;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.Principal;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;

public abstract class BaseLoginFilter
implements Filter {
    private static final Logger log = Logger.getLogger(BaseLoginFilter.class);
    private FilterConfig filterConfig = null;
    protected static final String ALREADY_FILTERED = "loginfilter.already.filtered";
    public static final String LOGIN_SUCCESS = "success";
    public static final String LOGIN_FAILED = "failed";
    public static final String LOGIN_ERROR = "error";
    public static final String LOGIN_NOATTEMPT = null;
    public static final String OS_AUTHSTATUS_KEY = "os_authstatus";
    private SecurityConfig securityConfig = null;

    public void init(FilterConfig config) {
        this.filterConfig = config;
    }

    public void destroy() {
        this.filterConfig = null;
    }

    public FilterConfig getFilterConfig() {
        return this.filterConfig;
    }

    public void setFilterConfig(FilterConfig filterConfig) {
        if (filterConfig != null) {
            this.init(filterConfig);
        }
    }

    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        boolean dbg = log.isDebugEnabled();
        if ((req = new SecurityHttpRequestWrapper((HttpServletRequest)req)).getAttribute(ALREADY_FILTERED) == null && this.getSecurityConfig().getController().isSecurityEnabled()) {
            req.setAttribute(ALREADY_FILTERED, (Object)Boolean.TRUE);
            req.setAttribute(OS_AUTHSTATUS_KEY, (Object)LOGIN_NOATTEMPT);
            HttpServletRequest request = (HttpServletRequest)req;
            HttpServletResponse response = (HttpServletResponse)res;
            if (dbg) {
                String url = request.getServletPath() + (request.getPathInfo() == null ? "" : request.getPathInfo()) + (request.getQueryString() == null ? "" : "?" + request.getQueryString());
                log.debug((Object)("____ Attempting login for : '" + url + "'"));
            }
            String status = this.login(request, response);
            request.setAttribute(OS_AUTHSTATUS_KEY, (Object)status);
            if (dbg) {
                log.debug((Object)("Login completed - set os_authstatus attribute to '" + status + "'"));
            }
            if (status == LOGIN_SUCCESS && this.redirectToOriginalDestination(request, response)) {
                return;
            }
            if (status == LOGIN_NOATTEMPT) {
                this.issuePossibleRedirectIfUserIsAlreadyLoggedIn((ServletRequest)req, request, response);
            }
        }
        chain.doFilter(req, res);
    }

    private void issuePossibleRedirectIfUserIsAlreadyLoggedIn(ServletRequest req, HttpServletRequest request, HttpServletResponse response) throws IOException {
        HttpSession session;
        Principal principal;
        if (request.getParameterMap().get("os_destination") != null && (principal = this.getAuthenticator().getUser(request)) != null && (session = ((HttpServletRequest)req).getSession()) != null && session.getAttribute(SecurityConfigFactory.getInstance().getOriginalURLKey()) == null) {
            this.redirectToOriginalDestination(request, response);
        }
    }

    public abstract String login(HttpServletRequest var1, HttpServletResponse var2);

    protected boolean redirectToOriginalDestination(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String redirectURL = (String)request.getSession().getAttribute(this.getSecurityConfig().getOriginalURLKey());
        if (redirectURL != null) {
            request.getSession().setAttribute(this.getSecurityConfig().getOriginalURLKey(), null);
        } else {
            redirectURL = request.getParameter("os_destination");
        }
        if (redirectURL == null) {
            return false;
        }
        if (!this.getSecurityConfig().getRedirectPolicy().allowedRedirectDestination(redirectURL, request)) {
            log.warn((Object)("Redirect request to '" + redirectURL + "' is not allowed. Will send user to the context root instead."));
            redirectURL = "/";
        }
        if (!this.isAbsoluteUrl(redirectURL)) {
            redirectURL = RedirectUtils.appendPathToContext(request.getContextPath(), redirectURL);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Logged In - redirecting to: " + redirectURL));
        }
        response.sendRedirect(redirectURL);
        return true;
    }

    protected boolean isAbsoluteUrl(String url) {
        try {
            URI uri = new URI(url);
            return uri.isAbsolute();
        }
        catch (URISyntaxException e) {
            return false;
        }
    }

    protected Authenticator getAuthenticator() {
        return this.getSecurityConfig().getAuthenticator();
    }

    protected SecurityConfig getSecurityConfig() {
        if (this.securityConfig == null) {
            this.securityConfig = (SecurityConfig)this.filterConfig.getServletContext().getAttribute("seraph_config");
        }
        return this.securityConfig;
    }

    private class SecurityHttpRequestWrapper
    extends HttpServletRequestWrapper {
        private HttpServletRequest request;

        public SecurityHttpRequestWrapper(HttpServletRequest request) {
            super(request);
            this.request = request;
        }

        public String getRemoteUser() {
            Principal user = this.getUserPrincipal();
            return user == null ? null : user.getName();
        }

        public Principal getUserPrincipal() {
            return BaseLoginFilter.this.getSecurityConfig().getAuthenticator().getUser(this.request);
        }
    }
}

