package com.atlassian.seraph.cookie;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.Cookie;

/**
 * Handles basic cookie tasks
 */
public interface CookieHandler
{
    /**
     * Invalidate the specified cookie and delete it from the response object.
     *
     * @param response The HttpServletResponse object, known as "response" in a JSP page.
     * @param cookieName The name of the cookie you want to delete.
     * @param path of the path the cookie you want to delete.
     */
    public void invalidateCookie(HttpServletRequest request, HttpServletResponse response, String cookieName, String path);


    /**
     * Returns the specified Cookie object, or null if the cookie does not exist.
     *
     * @param request The HttpServletRequest object, known as "request" in a
     *      JSP page.
     * @param name the name of the cookie.
     * @return the Cookie object if it exists, otherwise null.
     */
    public Cookie getCookie(HttpServletRequest request, String name);


    /**
     * Sets a cookie
     *
     * This will also put the cookie in a list of cookies to send with this request's response
     * (so that in case of a redirect occurring down the chain, the first filter
     * will always try to set this cookie again)
     *
     * The cookie secure flag is set if the request is secure.
     */
    public Cookie setCookie(HttpServletRequest request, HttpServletResponse response, String name, String value, int maxAge, String path);


    /**
     * Returns the value of the specified cookie as a String. If the cookie
     * does not exist, the method returns null.
     *
     * @param request the HttpServletRequest object, known as "request" in a
     *      JSP page.
     * @param name the name of the cookie
     * @return the value of the cookie, or null if the cookie does not exist.
     */
    public String getCookieValue(HttpServletRequest request, String name);

}
