package com.atlassian.seraph.auth;

import com.atlassian.seraph.config.SecurityConfig;
import com.atlassian.seraph.util.GroupCache;

import java.security.Principal;
import java.util.Collection;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;

/**
 * A simple RoleMapper which maps directly between group names and role names.
 *
 * If a user is a member of someGroup, the are in the 'someGroup' role.  Users can log in if they exist.
 */
public class GroupRoleMapper implements RoleMapper
{
    public void init(final Map<String, String> params, final SecurityConfig config)
    {}

    /**
     * Assume that roles == groups.
     */
    public boolean hasRole(final Principal user, final HttpServletRequest request, final String role)
    {
        final Collection<String> groups = GroupCache.getGroups(request);

        if ((groups == null) && (role == null))
        {
            return true;
        }
        else if (groups == null)
        {
            return false;
        }
        else
        {
            return groups.contains(role);
        }
    }

    /**
     * Users can login if they exist.

     */
    public boolean canLogin(final Principal user, final HttpServletRequest request)
    {
        return user != null;
    }
}
