/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.seraph.util;

import com.atlassian.seraph.config.SecurityConfig;
import com.atlassian.seraph.config.SecurityConfigFactory;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import javax.servlet.http.HttpServletRequest;

public class RedirectUtils {
    private static final String HTTP_BASIC_AUTH_HEADER = "Authorization";

    public static String getLoginUrl(HttpServletRequest request) {
        SecurityConfig securityConfig = SecurityConfigFactory.getInstance();
        String loginURL = securityConfig.getLoginURL();
        return RedirectUtils.getLoginURL(loginURL, request);
    }

    public static String getLinkLoginURL(HttpServletRequest request) {
        SecurityConfig securityConfig = SecurityConfigFactory.getInstance();
        String loginURL = securityConfig.getLinkLoginURL();
        return RedirectUtils.getLoginURL(loginURL, request);
    }

    private static String getLoginURL(String loginURL, HttpServletRequest request) {
        boolean externalLoginLink = RedirectUtils.isExternalLoginLink(loginURL);
        loginURL = RedirectUtils.replaceOriginalURL(loginURL, request, externalLoginLink);
        if (externalLoginLink) {
            return loginURL;
        }
        return request.getContextPath() + loginURL;
    }

    private static boolean isExternalLoginLink(String loginURL) {
        return loginURL.indexOf("://") != -1;
    }

    private static String replaceOriginalURL(String loginURL, HttpServletRequest request, boolean external) {
        int i = loginURL.indexOf("${originalurl}");
        if (i != -1) {
            String originalURL = RedirectUtils.getOriginalURL(request, external);
            String osDest = request.getParameter("os_destination");
            return loginURL.substring(0, i) + (osDest != null ? RedirectUtils.encodeUrl(osDest) : RedirectUtils.encodeUrl(originalURL)) + loginURL.substring(i + "${originalurl}".length());
        }
        return loginURL;
    }

    private static String encodeUrl(String url) {
        try {
            return URLEncoder.encode(url, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new AssertionError((Object)e);
        }
    }

    private static String getOriginalURL(HttpServletRequest request, boolean external) {
        String originalURL = (String)request.getAttribute("atlassian.core.seraph.original.url");
        if (originalURL != null) {
            if (external) {
                return RedirectUtils.getServerNameAndPath(request) + originalURL;
            }
            return originalURL;
        }
        if (external) {
            return request.getRequestURL() + (request.getQueryString() == null ? "" : "?" + request.getQueryString());
        }
        return request.getServletPath() + (request.getPathInfo() == null ? "" : request.getPathInfo()) + (request.getQueryString() == null ? "" : "?" + request.getQueryString());
    }

    public static String getServerNameAndPath(HttpServletRequest request) {
        StringBuffer buf = new StringBuffer();
        buf.append(request.getScheme()).append("://").append(request.getServerName());
        if (!("http".equals(request.getScheme()) && request.getServerPort() == 80 || "https".equals(request.getScheme()) && request.getServerPort() == 443)) {
            buf.append(":").append(request.getServerPort());
        }
        buf.append(request.getContextPath());
        return buf.toString();
    }

    public static boolean isBasicAuthentication(HttpServletRequest request, String basicAuthParameterName) {
        return RedirectUtils.hasHttpBasicAuthenticationRequestParameter(request, basicAuthParameterName) || RedirectUtils.hasHttpBasicAuthenticationRequestHeader(request);
    }

    static boolean hasHttpBasicAuthenticationRequestHeader(HttpServletRequest request) {
        return RedirectUtils.containsIgnoreCase(request.getHeader(HTTP_BASIC_AUTH_HEADER), "BASIC");
    }

    static boolean hasHttpBasicAuthenticationRequestParameter(HttpServletRequest request, String basicAuthParameterName) {
        String queryString = request.getQueryString() == null ? "" : request.getQueryString();
        queryString = "&" + queryString + "&";
        return queryString.indexOf("&" + basicAuthParameterName + "=" + "BASIC".toLowerCase() + "&") != -1;
    }

    public static String appendPathToContext(String context, String path) {
        String pathToAppend;
        if (context == null) {
            context = "";
        }
        if (path == null) {
            return context;
        }
        StringBuffer result = new StringBuffer(context);
        if (!context.endsWith("/")) {
            result.append("/");
        }
        if ((pathToAppend = path).startsWith("/")) {
            pathToAppend = pathToAppend.substring(1);
        }
        result.append(pathToAppend);
        return result.toString();
    }

    static boolean containsIgnoreCase(String str, String searchStr) {
        if (str == null || searchStr == null) {
            return false;
        }
        return RedirectUtils.contains(str.toUpperCase(), searchStr.toUpperCase());
    }

    static boolean contains(String str, String searchStr) {
        if (str == null || searchStr == null) {
            return false;
        }
        return str.indexOf(searchStr) >= 0;
    }
}

