/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.seraph.util;

import com.atlassian.seraph.cookie.CookieFactory;
import com.atlassian.seraph.cookie.InsecureCookieEncoder;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class CookieUtils {
    public static final String COOKIES_TO_SEND = "atlassian.core.web.cookies.unsent";
    private static final InsecureCookieEncoder cookieEncoder = new InsecureCookieEncoder();

    public static void invalidateCookie(HttpServletRequest request, HttpServletResponse response, String cookieName, String path) {
        CookieFactory.getCookieHandler().invalidateCookie(request, response, cookieName, path);
    }

    public static void invalidateCookie(HttpServletRequest request, HttpServletResponse response, String cookieName) {
        CookieFactory.getCookieHandler().invalidateCookie(request, response, cookieName, "/");
    }

    public static Cookie getCookie(HttpServletRequest request, String name) {
        return CookieFactory.getCookieHandler().getCookie(request, name);
    }

    public static Cookie setCookie(HttpServletRequest request, HttpServletResponse response, String name, String value, int maxAge, String path) {
        return CookieFactory.getCookieHandler().setCookie(request, response, name, value, maxAge, path);
    }

    public static String getCookieValue(HttpServletRequest request, String name) {
        return CookieFactory.getCookieHandler().getCookieValue(request, name);
    }

    public static String encodePasswordCookie(String username, String password) {
        return CookieUtils.encodePasswordCookie(username, password);
    }

    public static String encodePasswordCookie(String username, String password, String encoding) {
        return cookieEncoder.encodePasswordCookie(username, password, encoding);
    }

    public static String[] decodePasswordCookie(String cookieVal) {
        return cookieEncoder.decodePasswordCookie(cookieVal);
    }

    public static String[] decodePasswordCookie(String cookieVal, String encoding) {
        return cookieEncoder.decodePasswordCookie(cookieVal, encoding);
    }
}

