/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.seraph.util;

import com.atlassian.seraph.util.IPathMapper;
import com.atlassian.seraph.util.PathMapper;
import edu.emory.mathcs.backport.java.util.concurrent.locks.ReadWriteLock;
import edu.emory.mathcs.backport.java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;

public class CachedPathMapper
implements IPathMapper {
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private final PathMapper delegate = new PathMapper();
    private final Map cacheMap;
    private final Map cacheAllMap;

    public CachedPathMapper(Map cacheMap, Map cacheAllMap) {
        this.cacheMap = cacheMap;
        this.cacheAllMap = cacheAllMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String get(String path) {
        this.lock.readLock().lock();
        try {
            String result = (String)this.cacheMap.get(path);
            if (result != null) {
                String string = result;
                return string;
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
        return this.getWithLock(path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getWithLock(String path) {
        String result = this.delegate.get(path);
        this.lock.writeLock().lock();
        try {
            this.cacheMap.put(path, result);
            String string = result;
            return string;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection getAll(String path) {
        this.lock.readLock().lock();
        try {
            Collection result = (Collection)this.cacheAllMap.get(path);
            if (result != null) {
                Collection collection = result;
                return collection;
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
        return this.getAllWithLock(path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection getAllWithLock(String path) {
        Collection result = this.delegate.getAll(path);
        this.lock.writeLock().lock();
        try {
            this.cacheAllMap.put(path, result);
            Collection collection = result;
            return collection;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void set(Map patterns) {
        this.lock.writeLock().lock();
        try {
            Iterator it = patterns.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                this.put((String)entry.getKey(), (String)entry.getValue());
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(String key, String pattern) {
        this.lock.writeLock().lock();
        try {
            this.delegate.put(key, pattern);
            this.cacheMap.remove(key);
            this.cacheAllMap.remove(key);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public String toString() {
        return this.delegate.toString();
    }
}

