package com.atlassian.seraph.cookie;

import com.atlassian.seraph.config.SecurityConfig;

/**
 * Factory for cookie-related interfaces.
 * <p>
 * <b>Note:</b> Without initialisation the CookieHandler will return an <code>InsecureCookieEncoder</code>. However
 * after <code>init()</code> has been called an <code>EncryptedCookieEncoder</code> will be returned.
 */
public class CookieFactory
{
    private static CookieHandler cookieHandler = new DefaultCookieHandler();
    private static CookieEncoder cookieEncoder = new InsecureCookieEncoder();

    public static void init(SecurityConfig config)
    {
        cookieEncoder = new EncryptedCookieEncoder(config.getCookieEncoding());
    }

    public static CookieHandler getCookieHandler()
    {
        return cookieHandler;
    }

    public static CookieEncoder getCookieEncoder() 
    {
        return cookieEncoder;
    }

    public static void setCookieHandler(CookieHandler handler)
    {
        cookieHandler = handler;
    }

    public static void setCookieEncoder(CookieEncoder encoder) {
        cookieEncoder = encoder;
    }
}
