/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.seraph.service;

import com.atlassian.seraph.SecurityService;
import com.atlassian.seraph.config.SecurityConfig;
import com.atlassian.seraph.util.CachedPathMapper;
import com.atlassian.seraph.util.PathMapper;
import com.opensymphony.util.ClassLoaderUtil;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import javax.servlet.http.HttpServletRequest;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.collections.LRUMap;
import org.apache.log4j.Category;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import webwork.config.Configuration;

public class WebworkService
implements SecurityService {
    private static final Category log = Category.getInstance((Class)WebworkService.class);
    private final String ROLES_REQUIRED_ATTR = "roles-required";
    private PathMapper actionMapper = new CachedPathMapper((Map)new LRUMap(500), (Map)new LRUMap(10));
    private Map rolesMap = new HashMap();
    private String extension = "action";

    public void init(Map params, SecurityConfig config) {
        try {
            this.extension = (String)params.get("action.extension");
            this.configureActionMapper(this.extension);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void configureActionMapper(String extension) {
        try {
            String actionResourcePath = (String)Configuration.get((String)"webwork.configuration.xml");
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            URL fileUrl = ClassLoaderUtil.getResource((String)(actionResourcePath + ".xml"), this.getClass());
            if (fileUrl == null) {
                fileUrl = ClassLoaderUtil.getResource((String)("/" + actionResourcePath + ".xml"), this.getClass());
            }
            if (fileUrl == null) {
                throw new IllegalArgumentException("No such XML file:/" + actionResourcePath + ".xml");
            }
            Document doc = factory.newDocumentBuilder().parse(fileUrl.toString());
            NodeList actions = doc.getElementsByTagName("action");
            String rootRolesRequired = this.overrideRoles(null, doc.getDocumentElement());
            for (int i = 0; i < actions.getLength(); ++i) {
                Element action = (Element)actions.item(i);
                String actionName = action.getAttribute("name");
                String actionAlias = action.getAttribute("alias");
                String actionRolesRequired = this.overrideRoles(rootRolesRequired, action);
                if (actionRolesRequired != null) {
                    if (actionAlias != null) {
                        this.actionMapper.put(actionAlias, "/" + actionAlias + "." + extension);
                        this.rolesMap.put(actionAlias, actionRolesRequired);
                        this.actionMapper.put(actionAlias + "!*", "/" + actionAlias + "!*." + extension);
                        this.rolesMap.put(actionAlias + "!*", actionRolesRequired);
                    }
                    if (actionName != null) {
                        this.actionMapper.put(actionName, "/" + actionName + "." + extension);
                        this.rolesMap.put(actionName, actionRolesRequired);
                        this.actionMapper.put(actionName + "!*", "/" + actionName + "!*." + extension);
                        this.rolesMap.put(actionName + "!*", actionRolesRequired);
                    }
                }
                NodeList commands = action.getElementsByTagName("command");
                for (int j = 0; j < commands.getLength(); ++j) {
                    Element command = (Element)commands.item(j);
                    String cmdRolesRequired = this.overrideRoles(actionRolesRequired, command);
                    String commandAlias = command.getAttribute("alias");
                    if (commandAlias == null || cmdRolesRequired == null) continue;
                    this.actionMapper.put(commandAlias, "/" + commandAlias + "." + extension);
                    this.rolesMap.put(commandAlias, cmdRolesRequired);
                }
            }
        }
        catch (Exception ex) {
            log.error((Object)("Exception: " + ex), (Throwable)ex);
        }
    }

    private String overrideRoles(String rolesRequired, Element action) {
        if (action.hasAttribute("roles-required")) {
            return action.getAttribute("roles-required");
        }
        return rolesRequired;
    }

    public void destroy() {
    }

    public Set getRequiredRoles(HttpServletRequest request) {
        HashSet<String> requiredRoles = new HashSet<String>();
        String currentURL = request.getRequestURI();
        int lastSlash = currentURL.lastIndexOf(47);
        String targetURL = lastSlash > -1 ? currentURL.substring(lastSlash) : currentURL;
        String actionMatch = this.actionMapper.get(targetURL);
        if (actionMatch != null) {
            String rolesStr = (String)this.rolesMap.get(actionMatch);
            StringTokenizer st = new StringTokenizer(rolesStr, ", ");
            while (st.hasMoreTokens()) {
                requiredRoles.add(st.nextToken());
            }
        }
        return requiredRoles;
    }
}

