/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.seraph.filter;

import com.atlassian.seraph.auth.Authenticator;
import com.atlassian.seraph.auth.AuthenticatorException;
import com.atlassian.seraph.config.SecurityConfig;
import com.atlassian.seraph.interceptor.LoginInterceptor;
import com.atlassian.seraph.util.RedirectUtils;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.Principal;
import java.util.Iterator;
import java.util.List;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Category;

public class LoginFilter
implements Filter {
    private FilterConfig config = null;
    private static final Category log = Category.getInstance((Class)LoginFilter.class);
    public static final String ALREADY_FILTERED = "loginfilter.already.filtered";
    public static final String LOGIN_SUCCESS = "success";
    public static final String LOGIN_FAILED = "failed";
    public static final String LOGIN_ERROR = "error";
    public static final String LOGIN_NOATTEMPT = null;
    public static final String OS_AUTHSTATUS_KEY = "os_authstatus";
    private SecurityConfig securityConfig = null;

    public void init(FilterConfig config) {
        this.config = config;
    }

    public void destroy() {
        this.config = null;
    }

    public FilterConfig getFilterConfig() {
        return this.config;
    }

    public void setFilterConfig(FilterConfig filterConfig) {
        if (filterConfig != null) {
            this.init(filterConfig);
        }
    }

    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        if ((req = new SecurityHttpRequestWrapper((HttpServletRequest)req)).getAttribute(ALREADY_FILTERED) != null || !this.getSecurityConfig().getController().isSecurityEnabled()) {
            chain.doFilter(req, res);
            return;
        }
        req.setAttribute(ALREADY_FILTERED, (Object)Boolean.TRUE);
        req.setAttribute(OS_AUTHSTATUS_KEY, (Object)LOGIN_NOATTEMPT);
        HttpServletRequest request = (HttpServletRequest)req;
        HttpServletResponse response = (HttpServletResponse)res;
        String username = request.getParameter("os_username");
        String password = request.getParameter("os_password");
        boolean persistentLogin = "true".equals(request.getParameter("os_cookie"));
        boolean loggedIn = false;
        if (username != null && password != null) {
            LoginInterceptor loginInterceptor;
            Iterator iterator;
            List interceptors = this.getSecurityConfig().getInterceptors(LoginInterceptor.class);
            log.debug((Object)"Username and Password are not null - processing login request");
            try {
                iterator = interceptors.iterator();
                while (iterator.hasNext()) {
                    loginInterceptor = (LoginInterceptor)iterator.next();
                    loginInterceptor.beforeLogin(request, response, username, password, persistentLogin);
                }
                loggedIn = this.getAuthenticator().login(request, response, username, password, persistentLogin);
                if (loggedIn) {
                    log.debug((Object)"Login was successful - setting attribute to \"Success\"");
                    request.setAttribute(OS_AUTHSTATUS_KEY, (Object)LOGIN_SUCCESS);
                } else {
                    log.debug((Object)"Login was not successful - setting attribute to \"Failed\"");
                    request.setAttribute(OS_AUTHSTATUS_KEY, (Object)LOGIN_FAILED);
                }
            }
            catch (AuthenticatorException e) {
                log.debug((Object)"Login was not successful, and exception was thrown - setting attribute to \"Error\"");
                request.setAttribute(OS_AUTHSTATUS_KEY, (Object)LOGIN_ERROR);
                e.printStackTrace();
                log.warn((Object)("Exception was thrown whilst logging in: " + e.getMessage()), (Throwable)e);
            }
            iterator = interceptors.iterator();
            while (iterator.hasNext()) {
                loginInterceptor = (LoginInterceptor)iterator.next();
                loginInterceptor.afterLogin(request, response, username, password, persistentLogin, (String)request.getAttribute(OS_AUTHSTATUS_KEY));
            }
        }
        if (loggedIn && this.redirectToOriginalDestination(request, response)) {
            return;
        }
        chain.doFilter(req, res);
    }

    protected boolean redirectToOriginalDestination(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String originalURL = (String)request.getSession().getAttribute(this.getSecurityConfig().getOriginalURLKey());
        String destinationURL = request.getParameter("os_destination");
        String redirectURL = null;
        if (originalURL != null) {
            request.getSession().setAttribute(this.getSecurityConfig().getOriginalURLKey(), null);
            redirectURL = originalURL;
        } else if (destinationURL != null) {
            redirectURL = destinationURL;
        }
        if (redirectURL == null) {
            return false;
        }
        if (!this.isAbsoluteUrl(redirectURL)) {
            redirectURL = RedirectUtils.appendPathToContext(request.getContextPath(), redirectURL);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Logged In - redirecting to: " + redirectURL));
        }
        response.sendRedirect(redirectURL);
        return true;
    }

    protected boolean isAbsoluteUrl(String url) {
        try {
            URI uri = new URI(url);
            return uri.isAbsolute();
        }
        catch (URISyntaxException e) {
            return false;
        }
    }

    protected Authenticator getAuthenticator() {
        return this.getSecurityConfig().getAuthenticator();
    }

    protected SecurityConfig getSecurityConfig() {
        if (this.securityConfig == null) {
            this.securityConfig = (SecurityConfig)this.config.getServletContext().getAttribute("seraph_config");
        }
        return this.securityConfig;
    }

    private class SecurityHttpRequestWrapper
    extends HttpServletRequestWrapper {
        private HttpServletRequest request;

        public SecurityHttpRequestWrapper(HttpServletRequest request) {
            super(request);
            this.request = request;
        }

        public String getRemoteUser() {
            Principal user = this.getUserPrincipal();
            return user == null ? null : user.getName();
        }

        public Principal getUserPrincipal() {
            return LoginFilter.this.getSecurityConfig().getAuthenticator().getUser(this.request);
        }
    }
}

