/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.seraph.config;

import com.atlassian.seraph.config.ConfigurationException;
import com.atlassian.seraph.config.SecurityConfig;
import com.atlassian.seraph.config.SecurityConfigImpl;

public class SecurityConfigFactory {
    private static SecurityConfig instance;

    public static SecurityConfig getInstance() {
        if (instance == null) {
            SecurityConfigFactory.loadInstance("seraph-config.xml");
        }
        return instance;
    }

    public static SecurityConfig getInstance(String configFileLocation) {
        if (instance == null) {
            SecurityConfigFactory.loadInstance(configFileLocation);
        }
        return instance;
    }

    public static void setSecurityConfig(SecurityConfig securityConfig) {
        instance = securityConfig;
    }

    private static void loadInstance(String configFileLocation) {
        try {
            instance = new SecurityConfigImpl(configFileLocation);
        }
        catch (ConfigurationException e) {
            e.printStackTrace();
            throw new RuntimeException("Could not load security config '" + configFileLocation + "': " + e.getMessage());
        }
    }

    private SecurityConfigFactory() {
    }
}

