/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.seraph.filter;

import com.atlassian.seraph.auth.AuthenticatorException;
import com.atlassian.seraph.filter.BaseLoginFilter;
import com.atlassian.seraph.interceptor.LoginInterceptor;
import java.util.Iterator;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Category;

public abstract class PasswordBasedLoginFilter
extends BaseLoginFilter {
    static final Category log = Category.getInstance((Class)PasswordBasedLoginFilter.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String login(HttpServletRequest request, HttpServletResponse response) {
        Iterator iterator3222;
        boolean dbg = log.isDebugEnabled();
        String status = LOGIN_NOATTEMPT;
        UserPasswordPair userPair = this.extractUserPasswordPair(request);
        if (userPair == null) {
            if (!dbg) return status;
            log.debug((Object)"UserPasswordPair object was null ???");
            return status;
        }
        if (userPair.userName == null || userPair.password == null) {
            return status;
        }
        List interceptors = this.getSecurityConfig().getInterceptors(LoginInterceptor.class);
        if (dbg) {
            log.debug((Object)("____ Username : '" + userPair.userName + "' and password provided - remember me : " + Boolean.toString(userPair.persistentLogin) + " - attempting login request"));
        }
        try {
            try {
                Iterator iterator2 = interceptors.iterator();
                while (iterator2.hasNext()) {
                    LoginInterceptor loginInterceptor = (LoginInterceptor)iterator2.next();
                    loginInterceptor.beforeLogin(request, response, userPair.userName, userPair.password, userPair.persistentLogin);
                }
                boolean loggedIn = this.getAuthenticator().login(request, response, userPair.userName, userPair.password, userPair.persistentLogin);
                status = loggedIn ? "success" : "failed";
            }
            catch (AuthenticatorException e) {
                if (dbg) {
                    log.debug((Object)("An exception occurred authenticating : '" + userPair.userName + "'"), (Throwable)e);
                }
                status = "failed";
                Object var10_12 = null;
                Iterator iterator3222 = interceptors.iterator();
                while (iterator3222.hasNext()) {
                    LoginInterceptor loginInterceptor = (LoginInterceptor)iterator3222.next();
                    loginInterceptor.afterLogin(request, response, userPair.userName, userPair.password, userPair.persistentLogin, status);
                }
                return status;
            }
            Object var10_11 = null;
            iterator3222 = interceptors.iterator();
        }
        catch (Throwable throwable) {
            Object var10_13 = null;
            Iterator iterator3222 = interceptors.iterator();
            while (true) {
                if (!iterator3222.hasNext()) {
                    throw throwable;
                }
                LoginInterceptor loginInterceptor = (LoginInterceptor)iterator3222.next();
                loginInterceptor.afterLogin(request, response, userPair.userName, userPair.password, userPair.persistentLogin, status);
            }
        }
        while (iterator3222.hasNext()) {
            LoginInterceptor loginInterceptor = (LoginInterceptor)iterator3222.next();
            loginInterceptor.afterLogin(request, response, userPair.userName, userPair.password, userPair.persistentLogin, status);
        }
        return status;
    }

    abstract UserPasswordPair extractUserPasswordPair(HttpServletRequest var1);

    public static final class UserPasswordPair {
        final String userName;
        final String password;
        final boolean persistentLogin;

        UserPasswordPair(String user, String password, boolean persistentLogin) {
            this.userName = user;
            this.password = password;
            this.persistentLogin = persistentLogin;
        }
    }
}

