/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.security.auth.trustedapps;

import com.atlassian.security.auth.trustedapps.BouncyCastleEncryptionProvider;
import com.atlassian.security.auth.trustedapps.CurrentApplication;
import com.atlassian.security.auth.trustedapps.EncryptedCertificate;
import com.atlassian.security.auth.trustedapps.EncryptionProvider;
import com.atlassian.security.auth.trustedapps.Null;
import java.security.PrivateKey;
import java.security.PublicKey;

public class DefaultCurrentApplication
implements CurrentApplication {
    private final EncryptionProvider encryptionProvider;
    protected final String id;
    protected final PublicKey publicKey;
    protected final PrivateKey privateKey;

    public DefaultCurrentApplication(EncryptionProvider encryptionProvider, PublicKey publicKey, PrivateKey privateKey, String id) {
        Null.not("encryptionProvider", encryptionProvider);
        Null.not("publicKey", publicKey);
        Null.not("privateKey", privateKey);
        Null.not("id", id);
        this.encryptionProvider = encryptionProvider;
        this.publicKey = publicKey;
        this.privateKey = privateKey;
        this.id = id;
    }

    public DefaultCurrentApplication(PublicKey publicKey, PrivateKey privateKey, String id) {
        this(new BouncyCastleEncryptionProvider(), publicKey, privateKey, id);
    }

    public EncryptedCertificate encode(String userName) {
        return this.encryptionProvider.createEncryptedCertificate(userName, this.privateKey, this.getID());
    }

    public String getID() {
        return this.id;
    }

    public PublicKey getPublicKey() {
        return this.publicKey;
    }
}

