/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.seraph.auth;

import com.atlassian.seraph.auth.AbstractAuthenticator;
import com.atlassian.seraph.auth.AuthenticatorException;
import com.atlassian.seraph.auth.RoleMapper;
import com.atlassian.seraph.config.SecurityConfig;
import com.atlassian.seraph.config.SecurityConfigFactory;
import com.atlassian.seraph.cookie.CookieFactory;
import com.atlassian.seraph.cookie.CookieHandler;
import com.atlassian.seraph.interceptor.LogoutInterceptor;
import com.atlassian.seraph.util.RedirectUtils;
import com.opensymphony.user.EntityNotFoundException;
import com.opensymphony.user.User;
import com.opensymphony.user.UserManager;
import com.opensymphony.user.provider.ejb.util.Base64;
import java.io.IOException;
import java.security.Principal;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;

public class DefaultAuthenticator
extends AbstractAuthenticator {
    public static final String LOGGED_IN_KEY = "seraph_defaultauthenticator_user";
    public static final String LOGGED_OUT_KEY = "seraph_defaultauthenticator_logged_out_user";
    private static final Logger log = Logger.getLogger((Class)DefaultAuthenticator.class);
    private String loginCookieKey;
    private String authType;
    private int autoLoginCookieAge;
    private String loginCookiePath;

    public void init(Map params, SecurityConfig config) {
        if (log.isDebugEnabled()) {
            log.debug((Object)(this.getClass().getName() + " $Revision: 16581 $ initializing"));
        }
        super.init(params, config);
        this.loginCookieKey = config.getLoginCookieKey();
        this.authType = config.getAuthType();
        this.autoLoginCookieAge = config.getAutoLoginCookieAge();
        this.loginCookiePath = config.getLoginCookiePath();
    }

    public boolean isUserInRole(HttpServletRequest request, String role) {
        return this.getRoleMapper().hasRole(this.getUser(request), request, role);
    }

    public boolean login(HttpServletRequest request, HttpServletResponse response, String username, String password, boolean cookie) throws AuthenticatorException {
        boolean dbg = log.isDebugEnabled();
        Principal user = this.getUser(username);
        CookieHandler cookieHandler = CookieFactory.getCookieHandler();
        if (user == null) {
            log.info((Object)("Cannot login user '" + username + "' as they do not exist."));
        } else {
            boolean authenticated = this.authenticate(user, password);
            if (dbg) {
                log.debug((Object)("User : " + username + " has " + (authenticated ? "been" : "no been") + " authenticated"));
            }
            if (authenticated) {
                request.getSession().setAttribute(LOGGED_IN_KEY, (Object)user);
                request.getSession().setAttribute(LOGGED_OUT_KEY, null);
                boolean canLogin = this.getRoleMapper().canLogin(user, request);
                if (dbg) {
                    log.debug((Object)("User : " + username + " " + (canLogin ? "can" : "CANT") + " login according to the RoleMapper"));
                }
                if (canLogin) {
                    if (cookie && response != null) {
                        cookieHandler.setCookie(request, response, this.getLoginCookieKey(), this.encodeCookie(username, password), this.autoLoginCookieAge, this.getCookiePath(request));
                    }
                    return true;
                }
                request.getSession().removeAttribute(LOGGED_IN_KEY);
            } else {
                log.info((Object)("Cannot login user '" + username + "' as they used an incorrect password"));
            }
        }
        if (response != null && cookieHandler.getCookie(request, this.getLoginCookieKey()) != null) {
            log.warn((Object)("User: " + username + " tried to login but they do not have USE permission or weren't found. Deleting cookie."));
            try {
                cookieHandler.invalidateCookie(request, response, this.getLoginCookieKey(), this.getCookiePath(request));
            }
            catch (Exception e) {
                log.error((Object)("Could not invalidate cookie: " + e), (Throwable)e);
            }
        }
        return false;
    }

    protected RoleMapper getRoleMapper() {
        return SecurityConfigFactory.getInstance().getRoleMapper();
    }

    protected Principal getUser(String username) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Looking in UserManager for user : " + username));
        }
        try {
            return UserManager.getInstance().getUser(username);
        }
        catch (EntityNotFoundException e) {
            log.warn((Object)("Could not find user : " + username + " in UserManager : " + (Object)((Object)e)));
            return null;
        }
    }

    protected boolean authenticate(Principal user, String password) {
        return ((User)user).authenticate(password);
    }

    public boolean logout(HttpServletRequest request, HttpServletResponse response) throws AuthenticatorException {
        LogoutInterceptor interceptor;
        boolean dbg = log.isDebugEnabled();
        if (dbg) {
            log.debug((Object)"logout requested.  Calling interceptors and clearing cookies");
        }
        List interceptors = this.getLogoutInterceptors();
        CookieHandler cookieHandler = CookieFactory.getCookieHandler();
        Iterator iterator = interceptors.iterator();
        while (iterator.hasNext()) {
            interceptor = (LogoutInterceptor)iterator.next();
            interceptor.beforeLogout(request, response);
        }
        request.getSession().setAttribute(LOGGED_IN_KEY, null);
        request.getSession().setAttribute(LOGGED_OUT_KEY, (Object)Boolean.TRUE);
        if (response != null && cookieHandler.getCookie(request, this.getLoginCookieKey()) != null) {
            try {
                cookieHandler.invalidateCookie(request, response, this.getLoginCookieKey(), this.getCookiePath(request));
            }
            catch (Exception e) {
                log.error((Object)("Could not invalidate cookie: " + e), (Throwable)e);
            }
        }
        iterator = interceptors.iterator();
        while (iterator.hasNext()) {
            interceptor = (LogoutInterceptor)iterator.next();
            interceptor.afterLogout(request, response);
        }
        return true;
    }

    public Principal getUser(HttpServletRequest request, HttpServletResponse response) {
        Principal basicAuthUser;
        boolean dbg = log.isDebugEnabled();
        if (request.getSession(false) != null) {
            Principal sessionUser = this.getUserFromSession(request);
            if (sessionUser != null) {
                if (dbg) {
                    log.debug((Object)"Session found; BUT user doesn't exist");
                }
                return sessionUser;
            }
        } else {
            Principal cookieUser = this.getUserFromCookie(request, response);
            if (cookieUser != null) {
                return cookieUser;
            }
            log.debug((Object)"Cannot log user in via a cookie");
        }
        if (RedirectUtils.isBasicAuthentication(request, this.authType) && (basicAuthUser = this.getUserFromBasicAuthentication(request, response)) != null) {
            return basicAuthUser;
        }
        if (dbg) {
            log.debug((Object)"User not logged in.");
        }
        return null;
    }

    protected Principal getUserFromCookie(HttpServletRequest request, HttpServletResponse response) {
        String[] values;
        boolean dbg = log.isDebugEnabled();
        String cookieName = this.getLoginCookieKey();
        Cookie cookie = CookieFactory.getCookieHandler().getCookie(request, cookieName);
        if (cookie == null) {
            return null;
        }
        String cookieValue = cookie.getValue();
        if (dbg) {
            log.debug((Object)("Found cookie : '" + cookieName + "' with value : '" + cookieValue + "'"));
        }
        if ((values = this.decodeCookie(cookieValue)) == null) {
            if (dbg) {
                log.debug((Object)("Unable to decode " + cookieName + " cookie with value : '" + cookieValue + "'"));
            }
            return null;
        }
        String username = values[0];
        String password = values[1];
        if (dbg) {
            log.debug((Object)("Got username : '" + username + "' and password from cookie, attempting to authenticate user"));
        }
        try {
            if (!this.login(request, response, username, password, false)) {
                return null;
            }
        }
        catch (Exception e) {
            log.warn((Object)("Cookie login for user : '" + username + "' failed with exception: " + e), (Throwable)e);
            return null;
        }
        if (dbg) {
            log.debug((Object)("Logged user : '" + username + "' in via a cookie"));
        }
        return this.getUserFromSession(request);
    }

    protected Principal getUserFromSession(HttpServletRequest request) {
        boolean dbg = log.isDebugEnabled();
        try {
            if (request.getSession().getAttribute(LOGGED_OUT_KEY) != null) {
                if (dbg) {
                    log.debug((Object)"Session found; user has already logged out");
                }
                return null;
            }
            if (request.getSession().getAttribute(LOGGED_IN_KEY) == null) {
                return null;
            }
            Principal principal = (Principal)request.getSession().getAttribute(LOGGED_IN_KEY);
            if (dbg) {
                if (principal == null) {
                    log.debug((Object)"Session found; BUT it has no Principal in it");
                } else {
                    log.debug((Object)("Session found; user : '" + principal.getName() + "' already logged in"));
                }
            }
            return principal;
        }
        catch (Exception e) {
            log.warn((Object)("Exception when retrieving user from session: " + e), (Throwable)e);
            return null;
        }
    }

    protected Principal getUserFromBasicAuthentication(HttpServletRequest request, HttpServletResponse response) {
        boolean dbg = log.isDebugEnabled();
        String header = request.getHeader("Authorization");
        if (header != null && header.startsWith("Basic ")) {
            if (dbg) {
                log.debug((Object)"Looking in Basic Auth headers");
            }
            String base64Token = header.substring(6);
            String token = new String(Base64.decode((byte[])base64Token.getBytes()));
            String username = "";
            String password = "";
            int delim = token.indexOf(":");
            if (delim != -1) {
                username = token.substring(0, delim);
                password = token.substring(delim + 1);
            }
            try {
                if (this.login(request, response, username, password, false)) {
                    if (dbg) {
                        log.debug((Object)("Logged in user : '" + username + "' via basic auth"));
                    }
                    return this.getUser(username);
                }
            }
            catch (AuthenticatorException e) {
                log.warn((Object)("Exception trying to login user : '" + username + "' via basic auth:" + e), (Throwable)e);
            }
            try {
                response.sendError(401);
            }
            catch (IOException e) {
                log.warn((Object)("Exception trying to send basic auth failed error: " + e), (Throwable)e);
            }
            return null;
        }
        if (response == null) {
            return null;
        }
        response.setStatus(401);
        response.setHeader("WWW-Authenticate", "BASIC realm=\"protected-area\"");
        return null;
    }

    protected String getCookiePath(HttpServletRequest request) {
        if (this.getLoginCookiePath() != null) {
            return this.getLoginCookiePath();
        }
        String path = request.getContextPath();
        if (path == null || path.equals("")) {
            return "/";
        }
        if (!path.startsWith("/")) {
            return "/" + path;
        }
        return path;
    }

    protected String getLoginCookieKey() {
        return this.loginCookieKey;
    }

    public String getAuthType() {
        return this.authType;
    }

    protected List getLogoutInterceptors() {
        return this.getConfig().getInterceptors(LogoutInterceptor.class);
    }

    protected String encodeCookie(String username, String password) {
        return CookieFactory.getCookieEncoder().encodePasswordCookie(username, password, this.getConfig().getCookieEncoding());
    }

    protected String[] decodeCookie(String value) {
        return CookieFactory.getCookieEncoder().decodePasswordCookie(value, this.getConfig().getCookieEncoding());
    }

    protected String getLoginCookiePath() {
        return this.loginCookiePath;
    }
}

