/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.security.auth.trustedapps;

import com.atlassian.security.auth.trustedapps.Application;
import com.atlassian.security.auth.trustedapps.ApplicationRetriever;
import com.atlassian.security.auth.trustedapps.EncryptionProvider;
import com.atlassian.security.auth.trustedapps.Null;
import com.atlassian.security.auth.trustedapps.ReaderApplicationRetriever;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;

public class URLApplicationRetriever
implements ApplicationRetriever {
    private static final String CERTIFICATE_URL_PATH = "/admin/appTrustCertificate";
    private final String baseUrl;
    private final EncryptionProvider encryptionProvider;

    public URLApplicationRetriever(String baseUrl, EncryptionProvider encryptionProvider) {
        Null.not("baseUrl", baseUrl);
        Null.not("encryptionProvider", encryptionProvider);
        this.baseUrl = baseUrl;
        this.encryptionProvider = encryptionProvider;
    }

    public Application getApplication() throws ApplicationRetriever.RetrievalException {
        String certUrl = this.baseUrl + CERTIFICATE_URL_PATH;
        try {
            URLConnection con = new URL(certUrl).openConnection();
            con.connect();
            InputStream in = con.getInputStream();
            InputStreamReader reader = new InputStreamReader(in);
            ReaderApplicationRetriever retriever = new ReaderApplicationRetriever(reader, this.encryptionProvider);
            return retriever.getApplication();
        }
        catch (FileNotFoundException e) {
            throw new ApplicationRetriever.ApplicationNotFoundException(e);
        }
        catch (MalformedURLException e) {
            throw new ApplicationRetriever.RemoteSystemNotFoundException(e);
        }
        catch (IOException e) {
            throw new ApplicationRetriever.RemoteSystemNotFoundException(e);
        }
    }
}

