/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.security.auth.trustedapps;

import com.atlassian.security.auth.trustedapps.ApplicationCertificate;
import com.atlassian.security.auth.trustedapps.BouncyCastleEncryptionProvider;
import com.atlassian.security.auth.trustedapps.CertificateTooOldException;
import com.atlassian.security.auth.trustedapps.DefaultRequestValidator;
import com.atlassian.security.auth.trustedapps.EncryptedCertificate;
import com.atlassian.security.auth.trustedapps.EncryptionProvider;
import com.atlassian.security.auth.trustedapps.IPMatcher;
import com.atlassian.security.auth.trustedapps.InvalidCertificateException;
import com.atlassian.security.auth.trustedapps.InvalidRequestException;
import com.atlassian.security.auth.trustedapps.Null;
import com.atlassian.security.auth.trustedapps.RequestValidator;
import com.atlassian.security.auth.trustedapps.TrustedApplication;
import com.atlassian.security.auth.trustedapps.URLMatcher;
import java.security.PublicKey;
import javax.servlet.http.HttpServletRequest;

public class DefaultTrustedApplication
implements TrustedApplication {
    protected final String id;
    protected final PublicKey publicKey;
    protected final long certificateTimeout;
    protected final RequestValidator requestValidator;
    protected final EncryptionProvider encryptionProvider;

    public DefaultTrustedApplication(EncryptionProvider encryptionProvider, PublicKey publicKey, String id, long certificateTimeout, RequestValidator requestValidator) {
        Null.not("encryptionProvider", encryptionProvider);
        Null.not("publicKey", publicKey);
        Null.not("id", id);
        Null.not("requestValidator", requestValidator);
        this.encryptionProvider = encryptionProvider;
        this.publicKey = publicKey;
        this.id = id;
        this.certificateTimeout = certificateTimeout;
        this.requestValidator = requestValidator;
    }

    public DefaultTrustedApplication(EncryptionProvider encryptionProvider, PublicKey key, String id, long certificateTimeout, URLMatcher urlMatcher, IPMatcher ipMatcher) {
        this(encryptionProvider, key, id, certificateTimeout, new DefaultRequestValidator(ipMatcher, urlMatcher));
    }

    public DefaultTrustedApplication(PublicKey key, String id, long certificateTimeout, URLMatcher urlMatcher, IPMatcher ipMatcher) {
        this(new BouncyCastleEncryptionProvider(), key, id, certificateTimeout, urlMatcher, ipMatcher);
    }

    public ApplicationCertificate decode(EncryptedCertificate encCert, HttpServletRequest request) throws InvalidCertificateException {
        ApplicationCertificate certificate = this.encryptionProvider.decodeEncryptedCertificate(encCert, this.publicKey, this.getID());
        this.checkCertificateExpiry(certificate);
        this.checkRequest(request);
        return certificate;
    }

    public String getID() {
        return this.id;
    }

    public PublicKey getPublicKey() {
        return this.publicKey;
    }

    private void checkCertificateExpiry(ApplicationCertificate certificate) throws InvalidCertificateException {
        if (certificate.getCreationTime().getTime() + this.certificateTimeout <= System.currentTimeMillis()) {
            throw new CertificateTooOldException(certificate, this.certificateTimeout);
        }
    }

    private void checkRequest(HttpServletRequest request) throws InvalidCertificateException {
        try {
            this.requestValidator.validate(request);
        }
        catch (InvalidRequestException e) {
            throw new InvalidCertificateException(e);
        }
    }
}

