/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.security.auth.trustedapps;

import com.atlassian.security.auth.trustedapps.ApplicationCertificate;
import com.atlassian.security.auth.trustedapps.BaseEncryptionProvider;
import com.atlassian.security.auth.trustedapps.DefaultApplicationCertificate;
import com.atlassian.security.auth.trustedapps.DefaultEncryptedCertificate;
import com.atlassian.security.auth.trustedapps.EncryptedCertificate;
import com.atlassian.security.auth.trustedapps.InvalidCertificateException;
import com.atlassian.security.auth.trustedapps.Null;
import com.atlassian.security.auth.trustedapps.SystemException;
import com.atlassian.security.auth.trustedapps.Transcoder;
import com.atlassian.security.auth.trustedapps.TransportErrorMessage;
import com.atlassian.security.auth.trustedapps.TrustedApplicationUtils;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.KeyGenerator;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class BouncyCastleEncryptionProvider
extends BaseEncryptionProvider {
    private static final Provider PROVIDER = new BouncyCastleProvider();
    private static final String STREAM_CIPHER = "RC4";
    private static final String ASYM_CIPHER = "RSA/NONE/NoPadding";
    private static final String ASYM_ALGORITHM = "RSA";
    private final SecretKeyFactory secretKeyFactory;
    private final Transcoder transcoder;

    public BouncyCastleEncryptionProvider() {
        this(new ValidatingSecretKeyFactory(new BCKeyFactory(), new TransmissionValidator()), new Transcoder.Base64Transcoder());
    }

    private BouncyCastleEncryptionProvider(SecretKeyFactory secretKeyFactory, Transcoder transcoder) {
        Null.not("secretKeyFactory", secretKeyFactory);
        Null.not("transcoder", transcoder);
        this.secretKeyFactory = secretKeyFactory;
        this.transcoder = transcoder;
    }

    public PublicKey toPublicKey(byte[] encodedForm) throws NoSuchAlgorithmException, InvalidKeySpecException, NoSuchProviderException {
        X509EncodedKeySpec pubKeySpec = new X509EncodedKeySpec(encodedForm);
        KeyFactory keyFactory = KeyFactory.getInstance(ASYM_ALGORITHM, PROVIDER);
        return keyFactory.generatePublic(pubKeySpec);
    }

    public PrivateKey toPrivateKey(byte[] encodedForm) throws NoSuchAlgorithmException, InvalidKeySpecException, NoSuchProviderException {
        PKCS8EncodedKeySpec pubKeySpec = new PKCS8EncodedKeySpec(encodedForm);
        KeyFactory keyFactory = KeyFactory.getInstance(ASYM_ALGORITHM, PROVIDER);
        return keyFactory.generatePrivate(pubKeySpec);
    }

    public KeyPair generateNewKeyPair() throws NoSuchAlgorithmException, NoSuchProviderException {
        KeyPairGenerator gen = KeyPairGenerator.getInstance(ASYM_ALGORITHM, PROVIDER);
        return gen.generateKeyPair();
    }

    public ApplicationCertificate decodeEncryptedCertificate(EncryptedCertificate encCert, PublicKey publicKey, String appId) throws InvalidCertificateException {
        BufferedReader in;
        try {
            Cipher asymCipher = Cipher.getInstance(ASYM_CIPHER, PROVIDER);
            asymCipher.init(2, publicKey);
            String encryptedMagicNumber = encCert.getMagicNumber();
            if (encryptedMagicNumber != null) {
                String magicNumber = new String(asymCipher.doFinal(this.transcoder.decode(encryptedMagicNumber)), "utf-8");
                TrustedApplicationUtils.validateMagicNumber("public key", appId, encCert.getProtocolVersion(), magicNumber);
            } else if (encCert.getProtocolVersion() != null) {
                throw new InvalidCertificateException(new TransportErrorMessage.BadMagicNumber("public key", appId));
            }
            byte[] secretKeyData = asymCipher.doFinal(this.transcoder.decode(encCert.getSecretKey()));
            SecretKeySpec secretKeySpec = new SecretKeySpec(secretKeyData, STREAM_CIPHER);
            Cipher symCipher = Cipher.getInstance(STREAM_CIPHER, PROVIDER);
            symCipher.init(2, secretKeySpec);
            byte[] decryptedData = symCipher.doFinal(this.transcoder.decode(encCert.getCertificate()));
            in = new BufferedReader(new InputStreamReader((InputStream)new ByteArrayInputStream(decryptedData), "utf-8"));
        }
        catch (NoSuchAlgorithmException e) {
            throw new AssertionError((Object)e);
        }
        catch (NoSuchPaddingException e) {
            throw new AssertionError((Object)e);
        }
        catch (NumberFormatException e) {
            throw new SystemException(appId, (Exception)e);
        }
        catch (IllegalBlockSizeException e) {
            throw new SystemException(appId, (Exception)e);
        }
        catch (BadPaddingException e) {
            throw new SystemException(appId, (Exception)e);
        }
        catch (InvalidKeyException e) {
            throw new InvalidCertificateException(new TransportErrorMessage.BadMagicNumber("secret key", appId));
        }
        catch (SecurityException e) {
            throw new InvalidCertificateException(new TransportErrorMessage.BadMagicNumber("secret key", appId));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        try {
            String created = in.readLine();
            String userName = in.readLine();
            TrustedApplicationUtils.validateMagicNumber("secret key", appId, encCert.getProtocolVersion(), in.readLine());
            long timeCreated = Long.parseLong(created);
            return new DefaultApplicationCertificate(appId, userName, timeCreated);
        }
        catch (NumberFormatException e) {
            throw new SystemException(appId, (Exception)e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public EncryptedCertificate createEncryptedCertificate(String userName, PrivateKey privateKey, String appId) {
        try {
            SecretKey secretKey = this.secretKeyFactory.generateSecretKey();
            Cipher symmetricCipher = Cipher.getInstance(STREAM_CIPHER, PROVIDER);
            symmetricCipher.init(1, secretKey);
            Cipher asymCipher = Cipher.getInstance(ASYM_CIPHER, PROVIDER);
            asymCipher.init(1, privateKey);
            String encryptedKey = this.transcoder.encode(asymCipher.doFinal(secretKey.getEncoded()));
            String encryptedMagic = this.transcoder.encode(asymCipher.doFinal(this.transcoder.getBytes(TrustedApplicationUtils.Constant.MAGIC)));
            StringWriter writer = new StringWriter();
            writer.write(String.valueOf(System.currentTimeMillis()));
            writer.write(10);
            writer.write(userName);
            writer.write(10);
            writer.write(TrustedApplicationUtils.Constant.MAGIC);
            writer.flush();
            byte[] encryptedData = symmetricCipher.doFinal(this.transcoder.getBytes(writer.toString()));
            String encodedData = this.transcoder.encode(encryptedData);
            return new DefaultEncryptedCertificate(appId, encryptedKey, encodedData, TrustedApplicationUtils.Constant.VERSION, encryptedMagic);
        }
        catch (InvalidKeyException e) {
            throw new AssertionError((Object)e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new AssertionError((Object)e);
        }
        catch (NoSuchPaddingException e) {
            throw new AssertionError((Object)e);
        }
        catch (IllegalBlockSizeException e) {
            throw new RuntimeException(appId, e);
        }
        catch (BadPaddingException e) {
            throw new RuntimeException(appId, e);
        }
    }

    static class TransmissionValidator
    implements SecretKeyValidator {
        TransmissionValidator() {
        }

        public boolean isValid(SecretKey secretKey) {
            byte[] encoded = secretKey.getEncoded();
            if (encoded.length != 16) {
                return false;
            }
            return encoded[0] != 0;
        }
    }

    static interface SecretKeyValidator {
        public boolean isValid(SecretKey var1);
    }

    static class ValidatingSecretKeyFactory
    implements SecretKeyFactory {
        private final SecretKeyFactory delegate;
        private final SecretKeyValidator validator;

        ValidatingSecretKeyFactory(SecretKeyFactory secretKeyFactory, SecretKeyValidator validator) {
            this.delegate = secretKeyFactory;
            this.validator = validator;
        }

        public SecretKey generateSecretKey() {
            SecretKey result = this.delegate.generateSecretKey();
            while (!this.validator.isValid(result)) {
                result = this.delegate.generateSecretKey();
            }
            return result;
        }
    }

    static class BCKeyFactory
    implements SecretKeyFactory {
        BCKeyFactory() {
        }

        public SecretKey generateSecretKey() {
            try {
                return KeyGenerator.getInstance(BouncyCastleEncryptionProvider.STREAM_CIPHER, PROVIDER).generateKey();
            }
            catch (NoSuchAlgorithmException e) {
                throw new AssertionError((Object)e);
            }
        }
    }

    static interface SecretKeyFactory {
        public SecretKey generateSecretKey();
    }
}

