/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.seraph.filter;

import com.atlassian.seraph.auth.AuthenticatorException;
import com.atlassian.seraph.filter.BaseLoginFilter;
import com.atlassian.seraph.interceptor.LoginInterceptor;
import java.util.Iterator;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Category;

public abstract class PasswordBasedLoginFilter
extends BaseLoginFilter {
    static final Category log = Category.getInstance((Class)PasswordBasedLoginFilter.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String login(HttpServletRequest request, HttpServletResponse response) {
        boolean dbg = log.isDebugEnabled();
        String status = LOGIN_NOATTEMPT;
        UserPasswordPair userPair = this.extractUserPasswordPair(request);
        if (userPair == null) {
            if (dbg) {
                log.debug((Object)"UserPasswordPair object was null ???");
            }
            return status;
        }
        if (userPair.userName == null || userPair.password == null) {
            return status;
        }
        List interceptors = this.getSecurityConfig().getInterceptors(LoginInterceptor.class);
        if (dbg) {
            log.debug((Object)("____ Username : '" + userPair.userName + "' and password provided - remember me : " + Boolean.toString(userPair.persistentLogin) + " - attempting login request"));
        }
        try {
            Iterator iterator = interceptors.iterator();
            while (iterator.hasNext()) {
                LoginInterceptor loginInterceptor = (LoginInterceptor)iterator.next();
                loginInterceptor.beforeLogin(request, response, userPair.userName, userPair.password, userPair.persistentLogin);
            }
            boolean loggedIn = this.getAuthenticator().login(request, response, userPair.userName, userPair.password, userPair.persistentLogin);
            status = loggedIn ? "success" : "failed";
        }
        catch (AuthenticatorException e) {
            if (dbg) {
                log.debug((Object)("An exception occurred authenticating : '" + userPair.userName + "'"), (Throwable)e);
            }
            status = "failed";
            return status;
        }
        finally {
            Iterator iterator = interceptors.iterator();
            while (iterator.hasNext()) {
                LoginInterceptor loginInterceptor = (LoginInterceptor)iterator.next();
                loginInterceptor.afterLogin(request, response, userPair.userName, userPair.password, userPair.persistentLogin, status);
            }
        }
        return status;
    }

    abstract UserPasswordPair extractUserPasswordPair(HttpServletRequest var1);

    public static final class UserPasswordPair {
        final String userName;
        final String password;
        final boolean persistentLogin;

        UserPasswordPair(String user, String password, boolean persistentLogin) {
            this.userName = user;
            this.password = password;
            this.persistentLogin = persistentLogin;
        }
    }
}

