package com.atlassian.security.auth.trustedapps;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;

/**
 * Take a URL and produce an {@link Application}.
 */
public class URLApplicationRetriever implements ApplicationRetriever
{
    private static final String CERTIFICATE_URL_PATH = "/admin/appTrustCertificate";

    private final String baseUrl;
    private final EncryptionProvider encryptionProvider;

    public URLApplicationRetriever(String baseUrl, EncryptionProvider encryptionProvider)
    {
        Null.not("baseUrl", baseUrl);
        Null.not("encryptionProvider", encryptionProvider);

        this.baseUrl = baseUrl;
        this.encryptionProvider = encryptionProvider;
    }

    public Application getApplication() throws RetrievalException
    {
        final String certUrl = baseUrl + CERTIFICATE_URL_PATH;
        try
        {
            final URLConnection con = new URL(certUrl).openConnection();
            con.connect();
            final InputStream in = con.getInputStream();
            final InputStreamReader reader = new InputStreamReader(in);
            final ReaderApplicationRetriever retriever = new ReaderApplicationRetriever(reader, encryptionProvider);
            return retriever.getApplication();
        }
        catch (FileNotFoundException e)
        {
            throw new ApplicationNotFoundException(e);
        }
        catch (MalformedURLException e)
        {
            throw new RemoteSystemNotFoundException(e);
        }
        catch (IOException e)
        {
            throw new RemoteSystemNotFoundException(e);
        }
    }
}