package com.atlassian.security.auth.trustedapps;

import javax.servlet.http.HttpServletRequest;



/**
 * Represents a trusted remote application.
 * This object used to verify a request claiming to have come from this application.
 * Such a request is required to have an encrypted certificate and application ID.
 * The certificate decryption and validation is a responsibility of this object. 
 */
public interface TrustedApplication extends Application
{
	/**
	 * This method decodes and validates the received certificate.
	 * 
	 * @param certificateStr - certificate string claiming to have come from this application
	 * 
	 * @return {@link ApplicationCertificate} object if validation succeeds
	 * 
	 * @throws InvalidCertificateException - if either decryption or validation fails
	 */
	public ApplicationCertificate decode(EncryptedCertificate certificate, HttpServletRequest request) throws InvalidCertificateException;
}
