package com.atlassian.security.auth.trustedapps;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

/**
 * Takes a set of patterns and assumes a URL matches if it starts with one of the given patterns.
 */
public class DefaultURLMatcher implements URLMatcher
{
    private final List patterns;

    public DefaultURLMatcher(Set patterns)
    {
        this.patterns = new LinkedList(patterns);
    }

    /**
     * returns true if the given URL starts with one of the given patterns and false otherwise
     */
    public boolean match(String urlPath)
    {
        if (patterns.isEmpty())
        {
            return true;
        }
        for (Iterator iterator = patterns.iterator(); iterator.hasNext();)
        {
            String pattern = (String) iterator.next();
            if (urlPath.startsWith(pattern))
            {
                return true;
            }
        }
        return false;
    }
}
