package com.atlassian.security.auth.trustedapps;

import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.util.HashMap;
import java.util.Map;

/**
 * Default implementation.
 */
public class DefaultTrustedApplicationsManager implements TrustedApplicationsManager
{
    protected final CurrentApplication application;
    protected final Map trustedApps;

    public DefaultTrustedApplicationsManager(CurrentApplication application, Map trustedApps)
    {
        Null.not("application", application);
        Null.not("trustedApps", trustedApps);

        this.application = application;
        this.trustedApps = trustedApps;
    }

    // ////CLOVER:OFF
    public DefaultTrustedApplicationsManager()
    {
        this(new BouncyCastleEncryptionProvider());
    }

    // /CLOVER:ON

    public DefaultTrustedApplicationsManager(EncryptionProvider encryptionProvider)
    {
        try
        {
            KeyPair keyPair = encryptionProvider.generateNewKeyPair();
            Null.not("keyPair", keyPair);

            application = new DefaultCurrentApplication(encryptionProvider, keyPair.getPublic(), keyPair.getPrivate(), encryptionProvider.generateUID());
            trustedApps = new HashMap();
        }
        catch (NoSuchAlgorithmException e)
        {
            throw new AssertionError(e);
        }
        catch (NoSuchProviderException e)
        {
            throw new AssertionError(e);
        }
    }

    public CurrentApplication getCurrentApplication()
    {
        return application;
    }

    public TrustedApplication getTrustedApplication(String id)
    {
        return (TrustedApplication) trustedApps.get(id);
    }
}