package com.atlassian.security.auth.trustedapps;

import java.security.PrivateKey;
import java.security.PublicKey;

public class DefaultCurrentApplication implements CurrentApplication
{
    private final EncryptionProvider encryptionProvider;

    protected final String id;
    protected final PublicKey publicKey;
    protected final PrivateKey privateKey;

    public DefaultCurrentApplication(EncryptionProvider encryptionProvider, PublicKey publicKey, PrivateKey privateKey, String id)
    {
        Null.not("encryptionProvider", encryptionProvider);
        Null.not("publicKey", publicKey);
        Null.not("privateKey", privateKey);
        Null.not("id", id);

        this.encryptionProvider = encryptionProvider;
        this.publicKey = publicKey;
        this.privateKey = privateKey;
        this.id = id;
    }

    public DefaultCurrentApplication(PublicKey publicKey, PrivateKey privateKey, String id)
    {
        this(new BouncyCastleEncryptionProvider(), publicKey, privateKey, id);
    }

    /**
     * Returned String can be used as a certificate to talk
     * to the server that trusts this application. I.e. the ID of this app and the certificate go into the following header parameters:
     * {@link CurrentApplication#HEADER_TRUSTED_APP_CERT}
     * {@link CurrentApplication#HEADER_TRUSTED_APP_ID}
     */
    public EncryptedCertificate encode(String userName)
    {
        return encryptionProvider.createEncryptedCertificate(userName, privateKey, getID());
    }

    public String getID()
    {
        return id;
    }

    public PublicKey getPublicKey()
    {
        return publicKey;
    }
}