package com.atlassian.security.auth.trustedapps;

/**
 * Represents current application. This object is used when establishing trust with other servers and requesting them to
 * perform privileged operations for this application.
 */
public interface CurrentApplication extends Application
{
    /**
     * @deprecated since 0.34 use {@link TrustedApplicationUtils.Header.Request#ID} instead.
     */
    public static final String HEADER_TRUSTED_APP_ID = TrustedApplicationUtils.Header.Request.ID;

    /**
     * @deprecated since 0.34 use {@link TrustedApplicationUtils.Header.Request#CERT} instead.
     */
    public static final String HEADER_TRUSTED_APP_CERT = TrustedApplicationUtils.Header.Request.CERTIFICATE;

    /**
     * @deprecated since 0.34 use {@link TrustedApplicationUtils.Header.Request#SECRET_KEY} instead.
     */
    public static final String HEADER_TRUSTED_APP_SECRET_KEY = TrustedApplicationUtils.Header.Request.SECRET_KEY;

    /**
     * @deprecated since 0.34 use {@link TrustedApplicationUtils.Header.Response#ERROR} instead.
     */
    public static final String HEADER_TRUSTED_APP_ERROR = TrustedApplicationUtils.Header.Response.ERROR;

    /**
     * @deprecated since 0.34 use {@link TrustedApplicationUtils.Header.Response#STATUS} instead.
     */
    public static final String HEADER_TRUSTED_APP_STATUS = TrustedApplicationUtils.Header.Response.STATUS;

    /**
     * Generates a new certificate that will be sent to the remote server when asking to perform privileged operation
     * for this application.
     * 
     * @return encrypted certificate representing this application
     * @throws InvalidCertificateException
     */
    public EncryptedCertificate encode(String userName);
}