/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.utils;

import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.function.TriConsumer;
import org.openqa.selenium.MutableCapabilities;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WrapsDriver;
import org.openqa.selenium.chrome.ChromeDriver;
import org.openqa.selenium.firefox.FirefoxDriver;
import org.openqa.selenium.ie.InternetExplorerDriver;
import org.openqa.selenium.remote.DesiredCapabilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class WebDriverUtil {
    private static final Logger log = LoggerFactory.getLogger(WebDriverUtil.class);

    private WebDriverUtil() {
        throw new AssertionError((Object)(WebDriverUtil.class.getName() + " is not supposed to be instantiated"));
    }

    public static boolean isFirefox(@Nonnull WebDriver driver) {
        return WebDriverUtil.getUnderlyingDriver(driver) instanceof FirefoxDriver;
    }

    public static boolean isChrome(@Nonnull WebDriver driver) {
        return WebDriverUtil.getUnderlyingDriver(driver) instanceof ChromeDriver;
    }

    public static boolean isIE(@Nonnull WebDriver driver) {
        return WebDriverUtil.getUnderlyingDriver(driver) instanceof InternetExplorerDriver;
    }

    @Nonnull
    public static WebDriver getUnderlyingDriver(@Nonnull WebDriver driver) {
        Objects.requireNonNull(driver, "driver");
        while (driver instanceof WrapsDriver) {
            driver = ((WrapsDriver)driver).getWrappedDriver();
        }
        return driver;
    }

    public static boolean isInstance(@Nonnull WebDriver driver, @Nonnull Class<?> type) {
        return type.isInstance(WebDriverUtil.getUnderlyingDriver(driver));
    }

    public static <T> T as(@Nonnull WebDriver driver, @Nonnull Class<T> type) {
        return type.cast(WebDriverUtil.getUnderlyingDriver(driver));
    }

    @Nonnull
    public static DesiredCapabilities createCapabilitiesFromString(@Nullable String capabilitiesList) {
        DesiredCapabilities capabilities = new DesiredCapabilities();
        WebDriverUtil.setPropertiesFromString(capabilitiesList, capabilities, MutableCapabilities::setCapability);
        return capabilities;
    }

    public static <T> void setPropertiesFromString(String propertiesString, T target, TriConsumer<T, String, String> setter) {
        if (!StringUtils.isEmpty((CharSequence)propertiesString)) {
            for (String property : propertiesString.split(";")) {
                String[] nameVal = property.split("=", 2);
                if (nameVal.length == 2) {
                    String name = nameVal[0].trim();
                    String valStr = nameVal[1].trim();
                    setter.accept(target, (Object)name, (Object)valStr);
                    continue;
                }
                log.error("Invalid property string: {}. Expected format: key1=value1;key2=value2", (Object)property);
            }
        }
    }
}

