/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.testing.rule;

import com.atlassian.pageobjects.browser.Browser;
import com.atlassian.pageobjects.browser.IgnoreBrowser;
import com.atlassian.pageobjects.browser.RequireBrowser;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.Collections;
import java.util.Objects;
import javax.inject.Inject;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assume;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IgnoreBrowserRule
implements TestRule {
    private static final Logger log = LoggerFactory.getLogger(IgnoreBrowserRule.class);
    private final Supplier<? extends Browser> currentBrowserSupplier;

    @Inject
    public IgnoreBrowserRule(Browser currentBrowser) {
        this((Supplier<? extends Browser>)((Supplier)() -> Objects.requireNonNull(currentBrowser, "currentBrowser")));
    }

    public IgnoreBrowserRule(Supplier<? extends Browser> currentBrowserSupplier) {
        this.currentBrowserSupplier = Objects.requireNonNull(currentBrowserSupplier, "currentBrowserSupplier");
    }

    public Statement apply(final Statement base, final Description description) {
        return new Statement(){

            public void evaluate() throws Throwable {
                Class clazz = description.getTestClass();
                Package pkg = clazz.getPackage();
                this.checkRequiredBrowsers(this.getRequired((RequireBrowser)description.getAnnotation(RequireBrowser.class)));
                this.checkRequiredBrowsers(this.getRequired(description.isSuite() ? null : clazz.getAnnotation(RequireBrowser.class)));
                this.checkRequiredBrowsers(this.getRequired(pkg.getAnnotation(RequireBrowser.class)));
                IgnoredBrowsers.fromAnnotation((IgnoreBrowser)description.getAnnotation(IgnoreBrowser.class)).checkBrowser(this.currentBrowser(), description);
                IgnoredBrowsers.fromAnnotation(description.isSuite() ? null : clazz.getAnnotation(IgnoreBrowser.class)).checkBrowser(this.currentBrowser(), description);
                base.evaluate();
            }

            private Iterable<Browser> getRequired(RequireBrowser requireBrowser) {
                if (requireBrowser != null) {
                    return ImmutableList.copyOf((Object[])requireBrowser.value());
                }
                return Collections.emptyList();
            }

            private void checkRequiredBrowsers(Iterable<Browser> required) {
                if (Iterables.isEmpty(required) || Iterables.contains(required, (Object)Browser.ALL)) {
                    return;
                }
                Browser latestBrowser = this.currentBrowser();
                if (!Iterables.contains(required, (Object)latestBrowser)) {
                    log.info(description.getDisplayName() + " ignored, since it requires one of " + required);
                    Assume.assumeThat(required, (Matcher)Matchers.hasItem((Object)latestBrowser));
                }
            }

            private Browser currentBrowser() {
                return (Browser)IgnoreBrowserRule.this.currentBrowserSupplier.get();
            }
        };
    }

    private static final class IgnoredBrowsers {
        private final Iterable<Browser> ignored;
        private final String reason;

        public static IgnoredBrowsers fromAnnotation(IgnoreBrowser ignoreBrowser) {
            if (ignoreBrowser == null) {
                return IgnoredBrowsers.empty();
            }
            return new IgnoredBrowsers((Iterable<Browser>)ImmutableList.copyOf((Object[])ignoreBrowser.value()), ignoreBrowser.reason());
        }

        public static IgnoredBrowsers empty() {
            return new IgnoredBrowsers(Collections.emptyList(), "");
        }

        private IgnoredBrowsers(Iterable<Browser> ignored, String reason) {
            this.ignored = ignored;
            this.reason = reason;
        }

        boolean isEmpty() {
            return Iterables.isEmpty(this.ignored);
        }

        void checkBrowser(Browser currentBrowser, Description description) {
            if (this.isEmpty()) {
                return;
            }
            for (Browser browser : this.ignored) {
                if (browser != currentBrowser && browser != Browser.ALL) continue;
                log.info(description.getDisplayName() + " ignored, reason: " + this.reason);
                Assume.assumeThat((Object)browser, (Matcher)Matchers.not((Object)currentBrowser));
                Assume.assumeThat((Object)browser, (Matcher)Matchers.not((Object)Browser.ALL));
            }
        }
    }
}

