/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.debug;

import com.atlassian.webdriver.debug.JavaScriptErrorInfo;
import com.atlassian.webdriver.debug.JavaScriptErrorInfoImpl;
import com.atlassian.webdriver.debug.JavaScriptErrorRetriever;
import com.atlassian.webdriver.utils.WebDriverUtil;
import com.google.common.collect.ImmutableList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import java.util.stream.StreamSupport;
import org.openqa.selenium.UnsupportedCommandException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.openqa.selenium.remote.SessionId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenericJavaScriptErrorRetriever
implements JavaScriptErrorRetriever {
    private static final Logger log = LoggerFactory.getLogger(GenericJavaScriptErrorRetriever.class);
    private static final Map<SessionId, Boolean> errorRetrievalSupportedCache = new ConcurrentHashMap<SessionId, Boolean>();
    private final Supplier<? extends WebDriver> webDriver;

    public GenericJavaScriptErrorRetriever(Supplier<? extends WebDriver> webDriver) {
        this.webDriver = webDriver;
    }

    @Override
    public boolean isErrorRetrievalSupported() {
        SessionId sessionId = WebDriverUtil.as(this.webDriver.get(), RemoteWebDriver.class).getSessionId();
        return errorRetrievalSupportedCache.computeIfAbsent(sessionId, ignored -> {
            try {
                return this.webDriver.get().manage().logs().getAvailableLogTypes().contains("browser");
            }
            catch (UnsupportedCommandException e) {
                return false;
            }
            catch (WebDriverException e) {
                log.warn("WebDriverException during evaluation if 'error retrieval' is supported... probably buggy browser/driver", (Throwable)e);
                return false;
            }
        });
    }

    @Override
    public Iterable<JavaScriptErrorInfo> getErrors() {
        if (this.isErrorRetrievalSupported()) {
            return () -> StreamSupport.stream(this.webDriver.get().manage().logs().get("browser").spliterator(), false).map(entry -> new JavaScriptErrorInfoImpl(entry.toString(), entry.getMessage())).iterator();
        }
        return ImmutableList.of();
    }
}

