/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver;

import com.atlassian.browsers.BrowserConfig;
import com.atlassian.fugue.retry.ExceptionHandler;
import com.atlassian.fugue.retry.RetryFactory;
import com.atlassian.pageobjects.browser.Browser;
import com.atlassian.webdriver.DefaultWebDriverContext;
import com.atlassian.webdriver.DesiredCapabilitiesFactory;
import com.atlassian.webdriver.LocalWebDriverFactory;
import com.atlassian.webdriver.RemoteWebDriverFactory;
import com.atlassian.webdriver.WebDriverContext;
import com.atlassian.webdriver.WebDriverProperties;
import com.atlassian.webdriver.browsers.chrome.ChromeBrowser;
import com.atlassian.webdriver.browsers.edge.EdgeBrowser;
import com.atlassian.webdriver.browsers.firefox.FirefoxBrowser;
import com.atlassian.webdriver.browsers.ie.IeBrowser;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.remote.DesiredCapabilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebDriverFactory {
    private static final Logger log = LoggerFactory.getLogger(WebDriverFactory.class);
    private static final int GET_DRIVER_RETRY_COUNT = WebDriverProperties.WEBDRIVER_INIT_RETRY.getSystemPropertyAsInt(1);

    private WebDriverFactory() {
    }

    public static WebDriverContext getDriverContext() {
        return WebDriverFactory.getDriverContext(null);
    }

    public static String getBrowserProperty() {
        return WebDriverProperties.WEBDRIVER_BROWSER.getSystemProperty("firefox");
    }

    public static boolean isBrowserHeadless() {
        return WebDriverProperties.WEBDRIVER_BROWSER_HEADLESS.getSystemPropertyAsBool();
    }

    public static Browser getBrowser() {
        String browserProperty = WebDriverFactory.getBrowserProperty();
        return WebDriverFactory.getBrowser(browserProperty);
    }

    public static Browser getBrowser(String browserProperty) {
        if (RemoteWebDriverFactory.matches(browserProperty)) {
            return RemoteWebDriverFactory.getBrowser(browserProperty);
        }
        return LocalWebDriverFactory.getBrowser(browserProperty);
    }

    public static WebDriverContext getDriverContext(BrowserConfig browserConfig) {
        Supplier<WebDriverContext> runnable = () -> WebDriverFactory.getDriverNoRetry(browserConfig);
        ExceptionHandler exceptionLogger = ex -> {
            log.warn("Error creating WebDriver object, retrying.. ({})", (Object)ex.toString());
            log.debug("Error creating WebDriver object - stack trace", (Throwable)ex);
        };
        return (WebDriverContext)RetryFactory.create(runnable::get, (int)GET_DRIVER_RETRY_COUNT, (ExceptionHandler)exceptionLogger).get();
    }

    private static WebDriverContext getDriverNoRetry(BrowserConfig browserConfig) {
        String browserProperty = WebDriverFactory.getBrowserProperty();
        if (RemoteWebDriverFactory.matches(browserProperty)) {
            log.info("Loading RemoteWebDriverFactory driver {}", (Object)browserProperty);
            return RemoteWebDriverFactory.getDriverContext(browserProperty);
        }
        String browserPath = LocalWebDriverFactory.getBrowserPath(browserProperty);
        Browser browserType = LocalWebDriverFactory.getBrowser(browserProperty);
        DesiredCapabilities capabilities = DesiredCapabilitiesFactory.defaultCapabilitiesForBrowser(browserType);
        DesiredCapabilities customCapabilities = DesiredCapabilitiesFactory.customCapabilitiesFromSystemProperty();
        DesiredCapabilities loggingCapabilities = DesiredCapabilitiesFactory.customCapabilitiesForLogging();
        capabilities.merge((Capabilities)customCapabilities);
        capabilities.merge((Capabilities)loggingCapabilities);
        Object driver = WebDriverFactory.getBrowserDriver(browserType, browserConfig, browserPath, (Capabilities)capabilities);
        if (driver == null) {
            log.error("Unknown browser: {}, defaulting to firefox.", (Object)browserProperty);
            browserType = Browser.FIREFOX;
            driver = new FirefoxBrowser().getDriver();
        }
        return new DefaultWebDriverContext((WebDriver)driver, browserType);
    }

    @Nullable
    private static WebDriver getBrowserDriver(Browser browserType, BrowserConfig browserConfig, String browserPath, @Nullable Capabilities capabilities) {
        switch (browserType) {
            case FIREFOX: {
                return FirefoxBrowser.getDriver(browserConfig, browserPath, capabilities);
            }
            case CHROME: {
                return ChromeBrowser.getDriver(browserConfig, browserPath, capabilities);
            }
            case EDGE: {
                return EdgeBrowser.createEdgeDriver(browserPath, browserConfig);
            }
            case IE: {
                return IeBrowser.createIeDriver(browserPath, browserConfig, capabilities);
            }
            case IPHONE_SIMULATOR: {
                throw new UnsupportedOperationException("iPhone simulator is no longer a supported Browser Type. Use remote iPhone driver instead");
            }
            case IPHONE: {
                throw new RuntimeException("iPhone driver must be configured with a url parameter");
            }
            case IPAD: {
                throw new RuntimeException("iPad driver must be configured with a url parameter");
            }
            case ANDROID_EMULATOR: {
                throw new UnsupportedOperationException("Android emulator is no longer a supported Browser Type. Use remote Android driver instead");
            }
            case ANDROID: {
                throw new RuntimeException("Android driver must be configured with a url parameter");
            }
            case SAFARI: {
                throw new UnsupportedOperationException("Safari is not a supported Browser Type");
            }
            case OPERA: {
                throw new UnsupportedOperationException("Opera is not a supported Browser Type");
            }
        }
        return null;
    }
}

