/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.visualcomparison;

import com.atlassian.annotations.ExperimentalApi;
import com.atlassian.selenium.visualcomparison.v2.settings.PagePart;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;

@ExperimentalApi
public final class VisualComparisonSupport {
    @Inject
    private WebDriver webDriver;

    @Nonnull
    public PagePart asPagePart(@Nonnull By locator) {
        return new LocatablePagePart(Objects.requireNonNull(locator, "locator"));
    }

    private final class LocatablePagePart
    implements PagePart {
        private final By by;
        private WebElement element;

        private LocatablePagePart(By by) {
            this.by = by;
        }

        public int getLeft() {
            return this.getElement().getLocation().getX();
        }

        public int getTop() {
            return this.getElement().getLocation().getY();
        }

        public int getRight() {
            return this.getLeft() + this.getElement().getSize().getWidth();
        }

        public int getBottom() {
            return this.getTop() + this.getElement().getSize().getHeight();
        }

        private WebElement getElement() {
            if (this.element == null) {
                this.element = VisualComparisonSupport.this.webDriver.findElement(this.by);
            }
            return this.element;
        }
    }
}

