/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.testing.simpleserver;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.io.InputStream;
import java.net.ServerSocket;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.Validate;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleServer {
    private static final Logger logger = LoggerFactory.getLogger(SimpleServer.class);
    public static final String HEADERS_SUFFIX = ".headers";
    private int port = 0;
    private Server server = null;
    private final Map<String, String> urlMappings;

    public static void main(String ... args) throws Exception {
        int preferredPort = 5555;
        if (args.length > 0) {
            preferredPort = SimpleServer.parsePort(args[0]);
        }
        SimpleServer server = new SimpleServer(preferredPort);
        server.startServer();
        int port = server.getPort();
        logger.info("Server started: http://localhost:" + port);
        Runtime.getRuntime().addShutdownHook(new Thread(new ServerShutdown(server)));
    }

    public SimpleServer(int port) {
        this(Maps.newHashMap(), port);
    }

    public SimpleServer() {
        this(Maps.newHashMap());
    }

    public SimpleServer(@Nonnull Map<String, String> urlMappings) {
        this.checkPort();
        this.urlMappings = ImmutableMap.copyOf(urlMappings);
    }

    public SimpleServer(@Nonnull Map<String, String> urlMappings, int port) {
        Validate.isTrue((port > 0 ? 1 : 0) != 0, (String)"Port must be a positive number", (Object[])new Object[0]);
        this.port = port;
        this.urlMappings = ImmutableMap.copyOf(urlMappings);
        this.checkPort();
    }

    public void stopServer() throws Exception {
        if (this.server != null) {
            this.server.stop();
        }
    }

    public void startServer() throws Exception {
        AbstractHandler handler = new AbstractHandler(){

            public void handle(String target, Request request, HttpServletRequest httpServletRequest, HttpServletResponse response) throws IOException {
                String uri = request.getRequestURI();
                if (uri.endsWith(".css")) {
                    response.setContentType("text/css");
                } else if (uri.endsWith(".js")) {
                    response.setContentType("application/javascript");
                } else {
                    response.setContentType("text/html");
                }
                InputStream inputStream = null;
                inputStream = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(uri.substring(1));
                if (inputStream == null && SimpleServer.this.urlMappings.containsKey(uri)) {
                    String filename = (String)SimpleServer.this.urlMappings.get(uri);
                    inputStream = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(filename);
                }
                if (inputStream != null) {
                    String contents = IOUtils.toString((InputStream)inputStream);
                    if (contents != null) {
                        response.getWriter().print(contents);
                    } else {
                        response.getWriter().println("<h1>Cannot read file at: " + uri + "</h1>");
                    }
                } else {
                    response.getWriter().println("<h1>File not found at: " + uri + "</h1>");
                }
                Map<String, Collection<String>> headers = this.getHeadersForPage(uri);
                headers.forEach((headerName, headerValues) -> headerValues.forEach(headerValue -> response.addHeader(headerName, headerValue)));
                response.setStatus(200);
                request.setHandled(true);
            }

            @Nonnull
            private Map<String, Collection<String>> getHeadersForPage(String uri) throws IOException {
                InputStream inputStream;
                String filename = uri.substring(1);
                int lastIdx = filename.lastIndexOf(".");
                String headersFilename = filename.substring(0, lastIdx) + SimpleServer.HEADERS_SUFFIX;
                if (lastIdx < 0) {
                    headersFilename = filename + SimpleServer.HEADERS_SUFFIX;
                }
                if ((inputStream = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(headersFilename)) != null) {
                    logger.info("While serving '{}' I'm using headers from '{}'", (Object)filename, (Object)headersFilename);
                    return IOUtils.readLines((InputStream)inputStream).stream().map(line -> line.split(":", 2)).filter(tab -> ((String[])tab).length == 2).collect(Collectors.toMap(tab -> tab[0], tab -> Collections.singletonList(tab[1]), (oldList, newList) -> Lists.newArrayList((Iterable)Iterables.concat((Iterable)oldList, (Iterable)newList))));
                }
                return Collections.emptyMap();
            }
        };
        this.server = new Server(this.port);
        this.server.setHandler((Handler)handler);
        this.server.start();
    }

    public int getPort() {
        return this.port;
    }

    private static int parsePort(String port) {
        try {
            return Integer.parseInt(port);
        }
        catch (NumberFormatException e) {
            throw new RuntimeException("Could not parse port, not a number: " + port, e);
        }
    }

    private void checkPort() {
        ServerSocket socket = null;
        try {
            socket = new ServerSocket(this.port);
            this.port = socket.getLocalPort();
        }
        catch (IOException e) {
            throw new RuntimeException("Error opening socket, port: " + this.port + " may already be in use", e);
        }
        finally {
            if (socket != null) {
                try {
                    socket.close();
                }
                catch (IOException e) {
                    logger.error("Error closing sockets", (Throwable)e);
                }
            }
        }
    }

    private static final class ServerShutdown
    implements Runnable {
        private final SimpleServer server;

        private ServerShutdown(SimpleServer server) {
            this.server = server;
        }

        @Override
        public void run() {
            try {
                logger.info("Shutting down SimpleServer at port " + this.server.getPort());
                this.server.stopServer();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }
}

