/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.browsers;

import com.atlassian.browsers.AbstractInstallConfigurator;
import com.atlassian.browsers.BrowserAutoInstaller;
import com.atlassian.browsers.BrowserConfig;
import com.atlassian.browsers.BrowserConfiguration;
import com.atlassian.browsers.InstallConfigurator;
import com.atlassian.webdriver.WebDriverProperties;
import com.atlassian.webdriver.browsers.WebDriverBrowserConfiguration;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nonnull;

public class AutoInstallConfiguration {
    public static BrowserConfig setupBrowser() {
        return AutoInstallConfiguration.setupBrowser(new WebDriverBrowserConfiguration());
    }

    public static BrowserConfig setupBrowser(BrowserConfiguration browserConfiguration) {
        final AtomicReference ref = new AtomicReference();
        BrowserAutoInstaller browserAutoInstaller = new BrowserAutoInstaller(browserConfiguration, (InstallConfigurator)new AbstractInstallConfigurator(){

            public void setupBrowser(@Nonnull BrowserConfig browserConfig) {
                ref.set(browserConfig);
                switch (browserConfig.getBrowserType()) {
                    case FIREFOX: {
                        WebDriverProperties.WEBDRIVER_FIREFOX_BIN.setSystemProperty(browserConfig.getBinaryPath());
                        break;
                    }
                    case CHROME: {
                        WebDriverProperties.WEBDRIVER_CHROME_BIN.setSystemProperty(browserConfig.getBinaryPath());
                        break;
                    }
                }
            }
        });
        browserAutoInstaller.setupBrowser();
        return (BrowserConfig)ref.get();
    }

    private AutoInstallConfiguration() {
        throw new AssertionError((Object)"Don't instantiate. It has static methods only.");
    }
}

