/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.utils;

import com.atlassian.webdriver.utils.Check;
import java.util.ArrayList;
import java.util.List;
import org.openqa.selenium.By;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;

public class Search {
    private Search() {
    }

    public static WebElement findElementWithChildElement(By searchElements, By childFind, WebDriver driver) {
        return Search.findElementWithChildElement(searchElements, childFind, driver.findElement(By.tagName((String)"body")));
    }

    public static WebElement findElementWithChildElement(By searchElements, By childFind, WebElement context) {
        List elements = context.findElements(searchElements);
        for (WebElement el : elements) {
            if (!Check.elementExists(childFind, (SearchContext)el)) continue;
            return el;
        }
        return null;
    }

    public static WebElement findElementWithText(By searchElements, String textValue, WebDriver driver) {
        return Search.findElementWithText(searchElements, textValue, driver.findElement(By.tagName((String)"body")));
    }

    public static WebElement findElementWithText(By searchElements, String textValue, WebElement context) {
        List elements = context.findElements(searchElements);
        for (WebElement el : elements) {
            if (!el.getText().equals(textValue)) continue;
            return el;
        }
        return null;
    }

    public static List<WebElement> findVisibleElements(By searchElements, SearchContext context) {
        ArrayList<WebElement> visibleElements = new ArrayList<WebElement>();
        for (WebElement element : context.findElements(searchElements)) {
            if (!element.isDisplayed()) continue;
            visibleElements.add(element);
        }
        return visibleElements;
    }
}

