/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.utils;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Optional;
import java.util.function.Supplier;

public class BaseUrlSupplierForHost
implements Supplier<String> {
    private final URI baseUrl;
    private final Supplier<Optional<String>> hostSupplier;

    public BaseUrlSupplierForHost(String baseUrl, Supplier<Optional<String>> hostSupplier) {
        this.baseUrl = URI.create(baseUrl);
        this.hostSupplier = hostSupplier;
    }

    @Override
    public String get() {
        return this.hostSupplier.get().map(this::createBaseUrlForHost).orElse(this.baseUrl).toString();
    }

    private URI createBaseUrlForHost(String host) {
        try {
            return new URI(this.baseUrl.getScheme(), this.baseUrl.getUserInfo(), host, this.baseUrl.getPort(), this.baseUrl.getPath(), this.baseUrl.getQuery(), this.baseUrl.getFragment());
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException("Could not supply new url for host:" + host + " and baseUrl:" + this.baseUrl);
        }
    }
}

